<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
        <th>Imagen</th>
        <th style="cursor: pointer" >Nombre<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Descripcion<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Estado</th>
        <th style="cursor: pointer" >Dar de baja/Borrar</th>
    </tr>
    </thead>
    <tbody>
    @foreach ($categorias as $categoria)
        <tr style="text-align: center">
            <td>
                <p>
                    <div style="background-image: url(/storage/categorias/{{$categoria->picture}});" class="bg-img-cat">
                    </div>
                </p>
            </td>
            <td>
                <p>{{$categoria->title}}</p>
            </td>
            <td>
                <p>{{$categoria->description}}</p>
            </td>
            <td>
                <p>@if($categoria->state == 1) Activa @else Deshabilitada @endif</p>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form @if($categoria->state == 1) action="{{ url('/baja-categoria') }}" @else action="{{ url('/activar-categoria') }}" @endif method="POST">
                        @csrf
                        <input type="number" name="id" value="{{ $categoria->id }}" style="display: none" hidden required />
                        <button type="submit" style="border: none;background-color: transparent">
                            @if($categoria->state == 1) <i class="fas fa-arrow-circle-down"></i> @else <i class="fas fa-arrow-circle-up"></i> @endif
                        </button>
                    </form>

                    <a  href="{{ url('/edit-categoria') . '/' . $categoria->id }}"><i style="color: gray" class="fa fa-pencil"></i></a>

                    <form action="{{ url('/borrar-categoria') }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <input type="number" name="id" value="{{ $categoria->id }}" style="display: none" hidden required />
                        <button type="submit" style="border: none;background-color: transparent">
                            <i style="color: gray" class="fa fa-trash"></i>
                        </button>
                    </form>
                </div>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
<div class="d-flex justify-content-center">
    {{$categorias->links() }}
</div>
