<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
            <th style="cursor: pointer" >#<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Estrellas<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Experiencia<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Usuario</th>
            <th style="cursor: pointer" >Opinión<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Activa</th>
            <th style="cursor: pointer" >Validar</th>
            <th style="cursor: pointer" >Borrar</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($califications as $calification)
        <tr>
            <td>
                <p>{{$calification->id}}</p>
            </td>
            <td style="min-width: 9rem;">
                <p>
                    {{$calification->stars}}
                    @for($i = 0; $i < $calification->stars; $i++)
                        <i class="fas fa-star"></i>
                    @endfor
                </p>
            </td>
            <td>
                <p>{{$calification->experiencia != null ? $calification->experiencia->title : "-"}}</p>
            </td>
            <td>
                <p>{{$calification->user->name}}</p>
            </td>
            <td>
                <p>{{$calification->opinion}}</p>
            </td>
            <td>
                <p>{!! $calification->valida_front == 1 ? "<strong style='color: #006600;'>Si</strong>" : "<strong style='color: #990000;'>No</strong>" !!}</p>
            </td>
            <td>
                <form action="{{ url('/saveCalification') }}" method="post" style="margin-bottom: 0px;">
                    <div style="justify-content: space-around" class="row">
                        @csrf
                        <input type="number"
                               name="id" value="{{ $calification->id }}"
                               style="display:none;" hidden required />
                        <button style="border: none;background-color: transparent" type="submit">
                            <i class="fas fa-check"></i>
                        </button>
                    </div>

                </form>
            </td>
            <td>
                <form action="{{ url('/borrarCalification') }}" method="post" style="margin-bottom: 0px;">
                    <div style="justify-content: space-around" class="row">
                        @csrf
                        @method('DELETE')
                        <input type="number"
                               name="id" value="{{ $calification->id }}"
                               style="display:none;" hidden required />
                        <button style="border: none;background-color: transparent" type="submit">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>

                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
<div class="d-flex justify-content-center">
    {{$califications->links() }}
</div>
