@extends('admin.layout.admin')

<style>
    .hidden{
        display: none;
    }
</style>

@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title">Datos obtenidos del excel</h3>
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="table_data" class="display expandable-table" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th style="cursor: pointer" >Nombre<i class="fas fa-caret-down"></i></th>
                                                <th style="cursor: pointer" >Correo<i class="fas fa-caret-down"></i></th>
                                                <th style="cursor: pointer" >Telefono<i class="fas fa-caret-down"></i></th>
                                                <th style="cursor: pointer" >Experiencia canjeada<i class="fas fa-caret-down"></i></th>
                                                <th style="cursor: pointer" >Codigo de Experiencia<i class="fas fa-caret-down"></i></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse ($results['users'] as $result)
                                                <tr>
                                                    <td>{{$result->name}}</td>
                                                    <td>{{$result->email}}</td>
                                                    <td>{{$result->phone}}</td>    
                                                    <td>{{$results['codes'][$loop->index]->experiencia->title}}</td>    
                                                    <td>{{$results['codes'][$loop->index]->code}}</td>    
                                                </tr>        
                                            @endforeach                 
                                        </tbody>
                                    </table>
                                    <br>
                                    <br>
                                    <div class="d-flex justify-content-center">
                                        <a  href="{{ route('excel.cargar') }}" >Volver</button>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
