@extends('admin.layout.admin')

<style>
 div.days div input[type=checkbox]  {
        display: none;
        }

        input[type=checkbox] + label {
        color: #ccc;
        cursor: pointer;
        }

        input[type=checkbox]:checked + label {
        color: #4b49ac;
        }

        .days0 {
            display: flex  !important;
        }
</style>

@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div style="display: flex;gap:1.5rem">
                            <h3 class="card-title">Crear nuevo codigo</h3>
                            <div class="days days0">
                                <div>
                                    <input onchange="create_medife_coupon(event)" type="checkbox" value="1" id="dayDom0">
                                    <label style="margin-left: 0.5rem" for="dayDom0">Crear codigo Medife | Ase </label>
                                </div>
                            </div>
                            <a href="{{ url('/codigos-de-descuento-monto') }}" class="btn btn-light">Código de descuento por monto</a>
                        </div>
                        @if($errors->any())
                            <p  class="alert alert-danger" >{{$errors->first()}}</p>
                        @endif
                        @if(isset($error))
                            <p style="color: darkred;">{{ $error }}</p>
                        @endif
                        @if (\Session::has('success'))
                            <div class="alert alert-success">
                                <ul>
                                    <li>{!! \Session::get('success') !!}</li>
                                </ul>
                            </div>
                        @endif
                        <div class="row">
                            <div id="normal_coupon" style="display: block" class=" col-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 form-group">
                                <form action="{{ url('/crear-codigo') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <label for="code">Codigo:</label>
                                    <input type="text" name="code" class="form-control" maxlength="10" placeholder="Ingrese un codigo (max 10 digitos)" required />
                                    <br>

                                    <label for="experiencia_id">Elija la experiencia:</label>
                                    <select name="experiencia_id"  class="form-control">
                                        @foreach($experiencias as $expe)
                                            <option value="{{ $expe->id }}">{{ $expe->title }}</option>
                                        @endforeach
                                    </select><br>


                                    <label for="user_buyer">Elija el comprador:</label>
                                    <select name="user_buyer"  class="form-control">
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select><br>


                                    <label for="user_gifted">Elija el beneficiario:</label>
                                    <select name="user_gifted"  class="form-control">
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select><br>

                                    <br>
                                    <br>

                                    <button type="submit" class="btn btn-success">Crear Codigo</button>
                                </form>
                            </div>
                            {{-- Cupon de medife --}}
                            <div id="medife_coupon" style="display: none" class="tablinks col-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 form-group">
                                <form autocomplete="off" action="{{ url('/crear-codigo') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div  class="alert alert-info">
                                        <p>Recorda que, con esta opcion seleccionada, todos los usuarios podran usar este codigo para cualquier experiencia solo 1 vez </p>
                                    </div>
                                    <label for="code">Codigo:</label><br>
                                    <input type="text" name="code" class="form-control" maxlength="15" placeholder="Ingrese un codigo (max 15 digitos)" required
                                    oninvalid="this.setCustomValidity('El codigo es requerido')" oninput="this.setCustomValidity('')"/>
                                    <input type="hidden" name="custom_code" value="custom" />
                                    <br>
                                    <label>Porcentaje de descuento:</label><br>
                                    <div style="position:relative; display: inline-block; ">
                                        <input min="1" max="100" type="number" name="discount" class="form-control" placeholder="Ingrese un porcentaje de descuento" required
                                        oninvalid="this.setCustomValidity('Debes cargar un porcentaje valido, entre el 1 y el 100')" oninput="this.setCustomValidity('')"/>
                                        <span style="position: absolute; top:1.2rem; right: 2.3rem; line-height:100%; vertical-align: middle;color: #4b49ac">%</span>
                                    </div>
                                    <br>
                                    <label for="experiencia_id">Experiencia beneficiaria:</label>
                                    <select onchange="checkOption(this.value)" name="experiencia_id"  class="form-control">
                                        <option id="all_experiences" value="custom">Todas</option>
                                        @foreach($experiencias as $expe)
                                            <option value="{{ $expe->id }}">{{ $expe->title }}</option>
                                        @endforeach
                                    </select><br>
                                    <br>
                                    <br>

                                    <button type="submit" class="btn btn-success">Crear Codigo</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<script>
function create_medife_coupon(evt) {
    if (evt.srcElement.checked == true) {
        document.getElementById('normal_coupon').style.display = "none";
        document.getElementById('medife_coupon').style.display = "block";
        }else{
            document.getElementById('medife_coupon').style.display = "none";
            document.getElementById('normal_coupon').style.display = "block";
            }
}

function checkOption(value) {
    if (value=='custom') {
        document.getElementsByClassName('alert-info')[0].style.display = "block";
        }else{
            document.getElementsByClassName('alert-info')[0].style.display = "none";
        }
}
</script>
@endsection

