@extends('admin.layout.admin')

<style>
 div.days div input[type=checkbox]  {
        display: none;
        }

        input[type=checkbox] + label {
        color: #ccc;
        cursor: pointer;
        }

        input[type=checkbox]:checked + label {
        color: #4b49ac;
        }

        .days0 {
            display: flex  !important;
        }
</style>

@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div style="display: flex;gap:1.5rem">
                            <h3 class="card-title">Codigos de descuento por monto</h3>
                        </div>
                        <div class="row">
                            <a class="btn btn-light" href="{{ url('/crear-codigo-monto') }}">
                                Crear nuevo
                            </a>
                        </div>
                        <div class="row">

                            <table id="table_data" class="display expandable-table" style="width:100%">
                                <thead>
                                <tr>
                                    <th style="cursor: pointer" >#<i class="fas fa-caret-down"></i></th>
                                    <th style="cursor: pointer" >Codigo<i class="fas fa-caret-down"></i></th>
                                    <th style="cursor: pointer" >Monto<i class="fas fa-caret-down"></i></th>
                                    <th style="cursor: pointer" >Borrar<i class="fas fa-caret-down"></i></th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($codigos as $codigo)

                                    <tr style="">
                                        <td>
                                            <p>{{$codigo->id}}</p>
                                        </td>
                                        <td>
                                            <p>{{$codigo->code}}</p>
                                        </td>
                                        <td>
                                            <p>{{$codigo->amount}}</p>
                                        </td>
                                        <td>
                                            <p>
                                                <form action="{{ url('/eliminar-codigo-monto') }}" method="post">
                                                    @csrf
                                                    <input type="hidden"
                                                           name="code_id"
                                                           value="{{ $codigo->id }}"
                                                           style="display: none;"
                                                    />
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </form>
                                            </p>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                            <div class="d-flex justify-content-center">
                                {{$codigos->links() }}
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

