@extends('admin.layout.admin')

<style>
    .hidden{
        display: none;
    }
</style>
@section('contenido')
<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    @switch($response)
                        @case(2)
                            <h3 class="card-title">Experiencias</h3>
                            @break
                        @case(3)
                            <h3 class="card-title">Categorias</h3>
                            @break
                        @case(4)
                            <h3 class="card-title">Experiencias</h3>
                            @break
                        @case(5)
                            <h3 class="card-title">Lugares</h3>
                            @break
                        @default
                            <p>Resultado</p>
                    @endswitch
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                @switch($response)
                                    @case(2)
                                        @include('admin.components.tablas/experiencias')
                                        @break
                                    @case(3)
                                        @include('admin.components.tablas/categorias')
                                        @break
                                    @case(4)
                                        @include('admin.components.tablas/experiencias')
                                        @break
                                    @case(5)
                                        @include('admin.components.tablas/lugares')
                                        @break
                                    @default
                                        <p>Criterio de busqueda incorrecto</p>
                                @endswitch
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    const buscador = document.getElementById("searchbar");
    const criterio=@json($response);
    buscador.placeholder='Buscar';

    $('<input>').attr({
        type: 'hidden',
        id: 'criterio_busqueda',
        name: 'criterio_busqueda',
        value: criterio
    }).appendTo(buscador.parentNode)
</script>


@endsection
