 AOS.init({
 	duration: 800,
 	easing: 'slide'
 });

 var registrando = false;

(function($) {

	"use strict";

	$(window).stellar({
    responsive: true,
    parallaxBackgrounds: true,
    parallaxElements: true,
    horizontalScrolling: false,
    hideDistantElements: false,
    scrollProperty: 'scroll'
  });


	var fullHeight = function() {

		$('.js-fullheight').css('height', $(window).height());
		$(window).resize(function(){
			$('.js-fullheight').css('height', $(window).height());
		});

	};
	fullHeight();

	// loader
	var loader = function() {
		setTimeout(function() {
			if($('#ftco-loader').length > 0) {
				$('#ftco-loader').removeClass('show');
			}
		}, 1);
	};
	loader();

	// Scrollax
   $.Scrollax();

	var carousel = function() {
		$('.home-slider').owlCarousel({
	    loop:true,
	    autoplay: true,
	    margin:0,
	    animateOut: 'fadeOut',
	    animateIn: 'fadeIn',
	    nav:true,
	    dots: true,
	    autoplayHoverPause: false,
	    items: 1,
	    navText : ["<span class='ion-ios-arrow-back'></span>","<span class='ion-ios-arrow-forward'></span>"],
	    responsive:{
	      0:{
	        items:1
	      },
	      600:{
	        items:1
	      },
	      1000:{
	        items:1
	      }
	    }
		});
		$('.anfitrion-slider').owlCarousel({
	    loop:true,
	    autoplay: true,
	    margin:0,
	    animateOut: 'fadeOut',
	    animateIn: 'fadeIn',
	    nav:true,
	    dots: false,
	    autoplayHoverPause: false,
	    items: 1,
	    navText : ["<span class='ion-ios-arrow-back'></span>","<span class='ion-ios-arrow-forward'></span>"],
	    responsive:{
	      0:{
	        items:1
	      },
	      600:{
	        items:1
	      },
	      1000:{
	        items:1
	      }
	    }
		});
		$('.carousel-testimony').owlCarousel({
			center: true,
			loop: true,
			items:1,
			margin: 30,
			stagePadding: 0,
			nav: false,
			navText: ['<span class="ion-ios-arrow-back">', '<span class="ion-ios-arrow-forward">'],
			responsive:{
				0:{
					items: 1
				},
				600:{
					items: 2
				},
				1000:{
					items: 3
				}
			}
		});
	};
	carousel();

	$('nav .dropdown').hover(function(){
		var $this = $(this);
		// 	 timer;
		// clearTimeout(timer);
		$this.addClass('show');
		$this.find('> a').attr('aria-expanded', true);
		// $this.find('.dropdown-menu').addClass('animated-fast fadeInUp show');
		$this.find('.dropdown-menu').addClass('show');
	}, function(){
		var $this = $(this);
			// timer;
		// timer = setTimeout(function(){
			$this.removeClass('show');
			$this.find('> a').attr('aria-expanded', false);
			// $this.find('.dropdown-menu').removeClass('animated-fast fadeInUp show');
			$this.find('.dropdown-menu').removeClass('show');
		// }, 100);
	});


	$('#dropdown04').on('show.bs.dropdown', function () {
	  console.log('show');
	});

	// scroll
	var scrollWindow = function() {
		$(window).scroll(function(){
			var $w = $(this),
					st = $w.scrollTop(),
					navbar = $('.ftco_navbar'),
					sd = $('.js-scroll-wrap');

			if (st > 150) {
				if ( !navbar.hasClass('scrolled') ) {
					navbar.addClass('scrolled');
				}
			}
			if (st < 150) {
				if ( navbar.hasClass('scrolled') ) {
					navbar.removeClass('scrolled sleep');
					$('#form-lupa').hide()
				}
			}
			if ( st > 350 ) {
				if ( !navbar.hasClass('awake') ) {
					navbar.addClass('awake');
				}
				$('#map').addClass('amapaArranca');

				if(sd.length > 0) {
					sd.addClass('sleep');
				}
			}
			if ( st < 350 ) {
				if ( navbar.hasClass('awake') ) {
					navbar.removeClass('awake');
					navbar.addClass('sleep');
				}
				$('#map').removeClass('amapaArranca');
				if(sd.length > 0) {
					sd.removeClass('sleep');
				}
			}
			if ( st < $w.height() ) {
				if ( st > 350 ) {
					$('#map').removeClass('amapaFin');
					$('#map').addClass('amapaArranca');
				}
			} else {
				$('#map').addClass('amapaFin');
				$('#map').removeClass('amapaArranca');
			}
		});
	};
	scrollWindow();


	var counter = function() {

		$('#section-counter').waypoint( function( direction ) {

			if( direction === 'down' && !$(this.element).hasClass('ftco-animated') ) {

				var comma_separator_number_step = $.animateNumber.numberStepFactories.separator(',')
				$('.number').each(function(){
					var $this = $(this),
						num = $this.data('number');
						console.log(num);
					$this.animateNumber(
					  {
					    number: num,
					    numberStep: comma_separator_number_step
					  }, 7000
					);
				});

			}

		} , { offset: '95%' } );

	}
	counter();

	var contentWayPoint = function() {
		var i = 0;
		$('.ftco-animate').waypoint( function( direction ) {

			if( direction === 'down' && !$(this.element).hasClass('ftco-animated') ) {

				i++;

				$(this.element).addClass('item-animate');
				setTimeout(function(){

					$('body .ftco-animate.item-animate').each(function(k){
						var el = $(this);
						setTimeout( function () {
							var effect = el.data('animate-effect');
							if ( effect === 'fadeIn') {
								el.addClass('fadeIn ftco-animated');
							} else if ( effect === 'fadeInLeft') {
								el.addClass('fadeInLeft ftco-animated');
							} else if ( effect === 'fadeInRight') {
								el.addClass('fadeInRight ftco-animated');
							} else {
								el.addClass('fadeInUp ftco-animated');
							}
							el.removeClass('item-animate');
						},  k * 50, 'easeInOutExpo' );
					});

				}, 100);

			}

		} , { offset: '95%' } );
	};
	contentWayPoint();


	// navigation
	var OnePageNav = function() {
		//~ $(".smoothscroll[href^='#'], #ftco-nav ul li a[href^='#']").on('click', function(e) {
		$(".smoothscroll[href^='#']").on('click', function(e) {
		 	e.preventDefault();

		 	var hash = this.hash,
		 			navToggler = $('.navbar-toggler');
		 	$('html, body').animate({
		    scrollTop: $(hash).offset().top
		  }, 700, 'easeInOutExpo', function(){
		    window.location.hash = hash;
		  });


		  if ( navToggler.is(':visible') ) {
		  	navToggler.click();
		  }
		});
		$('body').on('activate.bs.scrollspy', function () {
		  console.log('nice');
		})
	};
	OnePageNav();

	/* AJUSTES */
  var search_setfocusfunc = function () {
    $(".search-foc").on("focus", function () {
      $(".search-text-box").addClass("s_hide");
      console.log("hide");
    });

    $(".search-foc").on("blur", function () {
      $(".search-text-box").removeClass("s_hide");
      console.log("show");
    });
  };
  search_setfocusfunc();

  var bigsearch_button = function () {
    $("#nav-btn-bigsearch").on("click", function () {
      show_longbar();
    });
  };
  bigsearch_button();

  var show_longbar = function () {
    $("#nav-bigsearch").removeClass("scroll-hide");
    $("#ftco-navbar").addClass("long-navbar");
    $("#ftco-nav .navbar-nav").addClass("navabiertoBus");
    $("#nav-btn-bigsearch").addClass("scroll-hide");
  };

  var remove_long = function () {
    $("#nav-bigsearch").addClass("scroll-hide");
    $("#ftco-nav .navbar-nav").removeClass("navabiertoBus");
    $("#ftco-navbar").removeClass("long-navbar");
    $("#nav-btn-bigsearch").removeClass("scroll-hide");
    $("#ftco-nav").removeClass("show");
  };

	$('#formSearch, #formSearchH').on('submit', function(e) {
		var porcat = $(this).find('select[name="category"]').val();
		var porlug = $(this).find('select[name="lugar"]').val();
		var porpre = $(this).find('select[name="price"]').val();
		var porpal = $(this).find('input[name="wts"]').val();
		if(porcat!="X" || porlug!="X" || porpre!="X" || porpal!="") {
		} else {
			alert("Debes ingresar al menso un criterio de búsqueda.");
			e.preventDefault();
		}
	});

  var nav_bar_lostfocus = function () {
    $(document).mouseup(function (e) {
      var container = $("#ftco-navbar"); // busco la barra de navegacion
      var container_session = $("#nav-dropdown-content");

      // if the target of the click isn't the container nor a descendant of the container
      if (
        !container.is(e.target) && // no se hizo click en la barra
        container.has(e.target).length === 0 && // no se hizo click en un descendiente
        e.target != $("html").get(0)
      ) {
        // no es scroll
        remove_long();
      }

      if (
        !container_session.is(e.target) && // no se hizo click session
        container_session.has(e.target).length === 0 && // no se hizo click en un descendiente
        e.target != $("html").get(0)
      ) {
        // no es scroll
        /*
        console.log(!container_session.is(e.target));
        console.log(container_session.has(e.target).length);
        console.log(e.target);
        console.log(container_session);
        */
        close_session();
      }

    });
  };
  nav_bar_lostfocus();

  $("#profile-nav-container").ready(function () {
    //$("#profile-nav-container").addClass("noshow");
  });

  var ingresa_button_click = function () {
    $(document).on("click", "#ingresa-btn", function () {
      //  $("#ingresa-btn").on("click", function () {
      show_logged();
    });
  };
  ingresa_button_click();

  var show_logged = function() {
    //$("#logged-icon").addClass("show");
    $(".logged-icon-container").addClass("show");
    $(".mini-menu").removeClass("show");
  }

  var log_button = function () {
    $(document).on("click", "#logged-icon-container", function () {

      $(".nav-dropdown-content").addClass("show");
      //$("#nav-dropdown-content").removeClass("nav-dropdown-content");
    });
  }
  log_button();

  var close_session_button = function () {
    $(".close_session_button").on("click",function(){
      close_session_full();
    });
  };
  close_session_button();



  var close_session = function(){
    $(".nav-dropdown-content").removeClass("show");
  };

  var close_session_full = function(){
    $(".nav-dropdown-content").removeClass("show");
    $(".logged-icon-container").removeClass("show");
    $(".mini-menu").addClass("show");
  };

  var close_experiencias = function () {
    $("#close-exp").on("click", function () {
      close_exp();
    });
  };
  close_experiencias();

  var close_exp = function () {
    $("#map").addClass("btn-close-exp");
    $("#open-exp").addClass("show");
    $("#container-experiencias").addClass("container-experiencias-full-width")
    $("#container-experiencias").addClass("container-experiencias-mobile")
  };

  var open_experiencias = function () {
    $("#open-exp").on("click", function () {
      open_exp();
    });
  };
  open_experiencias();

  var open_exp = function () {
    $("#container-experiencias").removeClass("container-experiencias-full-width");
    $("#container-experiencias").removeClass("container-experiencias-mobile")
    $("#open-exp").removeClass("show");
    $("#map").removeClass("btn-close-exp")
  };



  /* END AJUSTES */


	// magnific popup
	$('.image-popup').magnificPopup({
    type: 'image',
    closeOnContentClick: true,
    closeBtnInside: false,
    fixedContentPos: true,
    mainClass: 'mfp-no-margins mfp-with-zoom', // class to remove default margin from left and right side
     gallery: {
      enabled: true,
      navigateByImgClick: true,
      preload: [0,1] // Will preload 0 - before current, and 1 after the current image
    },
    image: {
      verticalFit: true
    },
    zoom: {
      enabled: true,
      duration: 300 // don't foget to change the duration also in CSS
    }
  });

  $('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
    disableOn: 700,
    type: 'iframe',
    mainClass: 'mfp-fade',
    removalDelay: 160,
    preloader: false,

    fixedContentPos: false
  });


	$( ".datepickerF" ).datepicker({
		calendarWeeks: true,
		todayHighlight: true,
		autoclose: true,
		format: "dd/mm/yyyy",
		startView: 2
    });

	$( "#fecha_reserva_regalo_cont" ).datepicker({
		startDate: "+0d",
		format: "dd/mm/yyyy",
    }).on('changeDate', function(e){
       $('#fecha_reserva_regalo').val(e.format(0,"dd/mm/yyyy"));
    });
	if($( "#fecha_reserva_expe_sel" ).length) {
		$( "#fecha_reserva_expe_sel" ).datepicker({
			startDate: "+0d",
			daysOfWeekDisabled: dias_habilitados,
			datesDisabled: fechas_reservadas,
			format: "dd/mm/yyyy",
		}).on('changeDate', function(e){
			$('#fecha_reserva_expe').val(e.format(0,"dd/mm/yyyy"));

			var data = {};
			data.action = "getExpeHorarios";
			data.eid = expeID;
			data.fecha = e.format(0,"yyyy-mm-dd");
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					$('#ftco-loader').removeClass('show');
					if(data.res) {
						var lugares;
						$('#horario_sel').html('<option value="X">Seleccione</option>');
						for(var i=0;i<data.data.length;i++) {
							if(data.data[i].cantidadDisp>0) {
								var horatxt = (data.data[i].hora!=24)?data.data[i].hora:'Sin horario';
								if(data.data[i].max_personas_or != 0) {
									lugares = (data.data[i].cantidadDisp==1)?'1 lugar':data.data[i].cantidadDisp+' lugares';
									$('#horario_sel').append('<option value="'+data.data[i].hora+'">Hora: '+horatxt+' (Quedan '+lugares+')</option>');
								} else {
									$('#horario_sel').append('<option value="'+data.data[i].hora+'">Hora: '+horatxt+'</option>');
								}
							}
						}
						$('#contenedor_horario_sel').removeClass("d-none");
					} else {
						alert(data.message);
					}
				}
			});
		});
	}

  $('#book_date').datepicker({
	  'format': 'm/d/yyyy',
	  'autoclose': true
	});
	$('#book_time').timepicker();


	$('.filtrarPor').click(function(e) {
		e.preventDefault();
		ponerExpeFiltradasCat($(this).data('cateid'));
	});

	$('.btnModalComprarExpe').click(function(e) {
		e.preventDefault();
		$("#ReservarExperiencia").modal('show');
	});

	$('.btnCalificarExpe').click(function(e) {
		e.preventDefault();
		$('#expeNum').val($(this).data('exid'));
		$("#modalEvaluarExpe").modal('show');
	});

    $('button#submitRatingStar').on('click', function() {
        $.ajax({
			dataType: 'json',
			url: apiYeahURL,
			method: 'POST',
			type: 'POST', // For jQuery < 1.9
            data: {action:"evaluateExpe",rate: laststarrate,ciid: $('#expeNum').val()},
            success: function(response) {
				alert(response.message);
                $("#modalEvaluarExpe").modal('hide');
            }
        });
        return false;
    });

    var laststarrate = 4;

    $('.estrellaEva').mouseenter(function(){
		laststarrate = $(this).data('starnum');
		$(this).parent().find('.estrellaEva').each(function () {
			$(this).removeClass('estrella-on').addClass('estrella-off');
			if($(this).data('starnum')<=laststarrate) {
				$(this).removeClass('estrella-off').addClass('estrella-on');
			}
		});
	});

    $('.estrellaEva').mouseleave(function(){
	});

	$('.btnModalLoginFor').click(function(e) {
		e.preventDefault();
		$("#IniciarSesion").modal('show');
	});

	$('#cantidadnuevaexpe').on('change', function(e) {
		var valor = $(this).val();
		var total = valor*$('#precioExpe').val();
		$('#costoTotal').html("$"+total);
	});

    $('input[name="programado"]').on('change', function(er) {
		if(this.value=="2") {
			$('#cont_regalo_programado').removeClass('d-none');
		} else {
			$('#cont_regalo_programado').addClass('d-none');
		}
	});

    $('input[name="tipo_envio"]').on('change', function(er) {
		if(this.value=="2") {
			$('#direccoin_data').removeClass('d-none');
		} else {
			$('#direccoin_data').addClass('d-none');
		}
	});


	$('#ntmRealizarConsultaExpe').click(function(e) {
        e.preventDefault();
        $('#ingresar-duda').removeClass('conError');
        var expid = $(this).data('expe');
        var mensaje = $('#ingresar-duda').val();
        if(mensaje!="") {
			$('#ftco-loader').addClass('show');
			var data = {};
			data.action = "enviarConsulta";
			data.mensaje = mensaje;
			data.expid = expid;
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					$('#ftco-loader').removeClass('show');
					if(data.res) {
						$('#ingresar-duda').val('');
						alert(data.message);
						location.reload();
					} else {
						alert(data.message);
					}
				}
			});
		} else {
			$('#ingresar-duda').addClass('conError');
		}
	});


    $('#formRegalar').on('submit', function(e){
        e.preventDefault();
        $('#nombre, #apellido, #email, #direccion, #piso, #depto, #codigo_postal, #telfono, #localidad, #provincia').css('border-bottom','2px solid var(--secondary)');
        $('#fecha_reserva_regalo_cont').css('border-bottom','0');
		var error = 0 ;

		if ( $("#nombre").val() == "" )   { error = 1; $('#nombre').css('border-bottom','2px solid #F44336'); }
		if ( $("#apellido").val() == "" )   { error = 1; $('#apellido').css('border-bottom','2px solid #F44336'); }
		if ( ($("#email").val() == "") || (!validateEmail($("#email").val())) )   { error = 1; $('#email').css('border-bottom','2px solid #F44336'); }

        if($('input[name="tipo_envio"]:checked').val()==2) {
			if ( $("#direccion").val() == "" )   { error = 1; $('#direccion').css('border-bottom','2px solid #F44336'); }
			if ( $("#codigo_postal").val() == "" )   { error = 1; $('#codigo_postal').css('border-bottom','2px solid #F44336'); }
			if ( $("#telefono").val() == "" )   { error = 1; $('#telefono').css('border-bottom','2px solid #F44336'); }
			if ( $("#localidad").val() == "" )   { error = 1; $('#localidad').css('border-bottom','2px solid #F44336'); }
			if ( $("#provincia").val() == "" )   { error = 1; $('#provincia').css('border-bottom','2px solid #F44336'); }
		}

        if($('input[name="programado"]:checked').val()==2) {
			if ( $("#fecha_reserva_regalo").val() == "" )   { error = 1; $('#fecha_reserva_regalo_cont').css('border-bottom','2px solid #F44336'); }
		}

		if( error == 0){
			this.submit();
		} else {
			alert('Debes completar todos los campos requeridos.');
		}
    });

    $('#formReservar').on('submit', function(e){
        e.preventDefault();
        $('#horario_sel').css('border-bottom','2px solid var(--secondary)');
        $('#fecha_reserva_expe_sel').css('border-bottom','0');
		var error = 0 ;

		if ( $("#horario_sel").val() == "X" )   { error = 1; $('#horario_sel').css('border-bottom','2px solid #F44336'); }
		if ( $("#fecha_reserva_expe").val() == "" )   { error = 1; $('#fecha_reserva_expe_sel').css('border-bottom','2px solid #F44336'); }

		if( error == 0){
			this.submit();
		} else {
			alert('Debes completar todos los campos requeridos.');
		}
    });


    $('#formEditPerfil').on('submit', function(e){
		e.preventDefault();

		$('#msjregs').html('');
		$('.ocultomens').removeClass('.showed');
		var error = 0 ;

		if ( $("#nombre").val() == "" )   { error = 1; $('#msjregs').append('El nombre no puede estar vacío.<br>'); }
		if ( $("#apellido").val() == "" )   { error = 1; $('#msjregs').append('El apellido no puede estar vacío.<br>'); }
		if ( $("#telefono").val() == "" )   { error = 1; $('#msjregs').append('El teléfono no puede estar vacío.<br>'); }
		if ( $("#pais").val() == "X" )   { error = 1; $('#msjregs').append('Debe seleccionar un país.<br>'); }
		if ( $("#provincia").val() == "" )   { error = 1; $('#msjregs').append('La provincia no puede estar vacío.<br>'); }
		if ( $("#ciudad").val() == "" )   { error = 1; $('#msjregs').append('La ciudad no puede puede vacío.<br>'); }
		if($("#pass_1").val()!="" || $("#pass_2").val()!="") {
			if ( !validarPass($("#pass_1").val(), $("#pass_2").val()))   { error = 1; }
		}

		if( error == 0){
			this.submit();
		} else {
			$('.ocultomens').addClass('showed');
		}
	});


	$('#btnRegistro').click(function(e) {
		e.preventDefault();

			$('#msjregs').html('');
			$('.ocultomens').removeClass('.showed');
			var error = 0 ;
			console.log("VAlor del captcha en teoria es");
			var captcha=$("#g-recaptcha-response")
			console.log(captcha);
			if ( !$('#aceptatyc').is(':checked'))   { error = 1; $('#msjregs').append('Debe aceptar los términos y condiciones.<br>'); }
			if ( $("#nombre").val() == "" )   { error = 1; $('#msjregs').append('El nombre no puede estar vacío.<br>'); }
			if ( $("#apellido").val() == "" )   { error = 1; $('#msjregs').append('El apellido no puede estar vacío.<br>'); }
			if ( $("#telefono").val() == "" )   { error = 1; $('#msjregs').append('El teléfono no puede estar vacío.<br>'); }
			if ( $("#pais").val() == "X" )   { error = 1; $('#msjregs').append('Debe seleccionar un país.<br>'); }
			if ( $("#provincia").val() == "" )   { error = 1; $('#msjregs').append('La provincia no puede estar vacío.<br>'); }
			if ( $("#ciudad").val() == "" )   { error = 1; $('#msjregs').append('La ciudad no peude puede vacío.<br>'); }
			if ( ($("#email").val() == "" ) || (!validateEmail($("#email").val())) )  { error = 1; $('#msjregs').append('El email debe ser válido.<br>'); }
			if ( !validarPass($("#pass_1").val(), $("#pass_2").val()))   { error = 1; }

			if( error == 0){
				$("#formreg").submit();
			} else {
				$('.ocultomens').addClass('showed');
			}
	});


	$('#prodrec_prodid').click(function(e){
		e.preventDefault();
		var prodid = $(this).data('elid');
		if(prodid!=""|| prodid!=undefined) {
			$('#prodid').val(prodid);
			$('#formpedido').submit();
		} else {
			alert('Producto no seleccionado.');
		}
	});

})(jQuery);

$(document).ready(function(){
    $('#form_reg_0').on('submit', function(e){
        e.preventDefault();

		$('#nombre, #apellido, #domicilio, #fecha_nac, #sexo, #celular').css('border-bottom','2px solid var(--secondary)');
		var error = 0 ;

		if ( $("#nombre").val() == "" )   { error = 1; $('#nombre').css('border-bottom','2px solid #F44336'); }
		if ( $("#apellido").val() == "" )   { error = 1; $('#apellido').css('border-bottom','2px solid #F44336'); }
		if ( $("#domicilio").val() == "" )   { error = 1; $('#domicilio').css('border-bottom','2px solid #F44336'); }
		if ( $("#fecha_nac").val() == "" )   { error = 1; $('#fecha_nac').css('border-bottom','2px solid #F44336'); }
		if ( $("#sexo").val() == "" )   { error = 1; $('#sexo').css('border-bottom','2px solid #F44336'); }
		if ( $("#celular").val() == "" )   { error = 1; $('#celular').css('border-bottom','2px solid #F44336'); }
		if ( ($("#anf_reg_email").val() == "" ) || (!validateEmail($("#anf_reg_email").val())))   { error = 1; $('#anf_reg_email').css('border-bottom','2px solid #F44336'); }
		var valpass = validarPass2($("#anf_reg_pass").val(), $("#anf_reg_pass2").val());
		if (!valpass[0]) {
			error = 1; $('#anf_reg_pass').css('border-bottom','2px solid #F44336');
			error = 1; $('#anf_reg_pass2').css('border-bottom','2px solid #F44336');
		}
		var elformo = this;

		if( error == 0){
			$('#ftco-loader').addClass('show');
			var data = {};
			data.action = "checkAfitrion";
			data.email = $("#anf_reg_email").val();
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					$('#ftco-loader').removeClass('show');
					if(data.res) {
						elformo.submit();
					} else {
						error = 1; $('#anf_reg_email').css('border-bottom','2px solid #F44336');
						alert(data.message);
					}
				}
			});
        } else {
			var extra = (!valpass[0])?'\n'+valpass[1]:'';
			alert("Debes completar todos los campos."+extra);
		}
    });

    $('#form_reg_1').on('submit', function(e){
        e.preventDefault();

		$('#emp_razon_social, #emp_cuit, #emp_telefono, #emp_direccion, #emp_provincia, #emp_ciudad, #nombre_emp, #apellido_emp, #celular_e, #anf_reg_email_e, #anf_reg_pass_e, anf_reg_pass2_e').css('border-bottom','2px solid var(--secondary)');
		var error = 0 ;
		var elformo = this;

		if ( $("#emp_razon_social").val() == "" )   { error = 1; $('#emp_razon_social').css('border-bottom','2px solid #F44336'); }
		if ( $("#emp_cuit").val() == "" )   { error = 1; $('#emp_cuit').css('border-bottom','2px solid #F44336'); }
		if ( $("#emp_telefono").val() == "" )   { error = 1; $('#emp_telefono').css('border-bottom','2px solid #F44336'); }
		if ( $("#emp_direccion").val() == "" )   { error = 1; $('#emp_direccion').css('border-bottom','2px solid #F44336'); }
		if ( $("#emp_provincia").val() == "" )   { error = 1; $('#emp_provincia').css('border-bottom','2px solid #F44336'); }
		if ( $("#emp_ciudad").val() == "" )   { error = 1; $('#emp_ciudad').css('border-bottom','2px solid #F44336'); }
		if ( $("#nombre_emp").val() == "" )   { error = 1; $('#nombre_emp').css('border-bottom','2px solid #F44336'); }
		if ( $("#apellido_emp").val() == "" )   { error = 1; $('#apellido_emp').css('border-bottom','2px solid #F44336'); }
		if ( $("#celular_e").val() == "" )   { error = 1; $('#celular_e').css('border-bottom','2px solid #F44336'); }
		if ( ($("#anf_reg_email_e").val() == "" ) || (!validateEmail($("#anf_reg_email_e").val())))   { error = 1; $('#anf_reg_email_e').css('border-bottom','2px solid #F44336'); }
		var valpass = validarPass2($("#anf_reg_pass_e").val(), $("#anf_reg_pass2_e").val());
		if (!valpass[0]) {
			error = 1; $('#anf_reg_pass_e').css('border-bottom','2px solid #F44336');
			error = 1; $('#anf_reg_pass2_e').css('border-bottom','2px solid #F44336');
		}

		if( error == 0){
			$('#ftco-loader').addClass('show');
			var data = {};
			data.action = "checkAfitrion";
			data.email = $("#anf_reg_email_e").val();
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					$('#ftco-loader').removeClass('show');
					if(data.res) {
						elformo.submit();
					} else {
						error = 1; $('#anf_reg_email_e').css('border-bottom','2px solid #F44336');
						alert(data.message);
					}
				}
			});
        } else {
			var extra = (!valpass[0])?'\n'+valpass[1]:'';
			alert("Debes completar todos los campos."+extra);
		}
    });

    $('#form_reg_2').on('submit', function(e){
        e.preventDefault();

		$('#anf_reg_titulo, #anf_reg_desc2, #anf_reg_precio').css('border-bottom','2px solid var(--secondary)');
		var error = 0 ;

		if ( $("#anf_reg_titulo").val() == "" )   { error = 1; $('#anf_reg_titulo').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_desc2").val() == "" )   { error = 1; $('#anf_reg_desc2').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_precio").val() == "" )   { error = 1; $('#anf_reg_precio').css('border-bottom','2px solid #F44336'); }

		if( error == 0){
            this.submit();
        } else {
			alert("Debes completar todos los campos.");
		}
    });

    $('#form_reg_3').on('submit', function(e){
        e.preventDefault();

		$('#anf_reg_direccion, #anf_reg_provincia, #anf_reg_ciudad, input[name="anf_reg_hablaridioma"], #anf_reg_cat').css('border-bottom','2px solid var(--secondary)');
		$('input[name="anf_reg_hablaridioma"]').removeClass('conerror');

		var error = 0 ;

		if ( $("#anf_reg_direccion").val() == "" )   { error = 1; $('#anf_reg_direccion').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_provincia").val() == "X" )   { error = 1; $('#anf_reg_provincia').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_cat").val() == "X" )   { error = 1; $('#anf_reg_cat').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_ciudad").val() == "" )   { error = 1; $('#anf_reg_ciudad').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_idioma").val() == "" )   { error = 1; $('#anf_reg_idioma').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_cat").val() == "" )   { error = 1; $('#anf_reg_cat').css('border-bottom','2px solid #F44336'); }
		if ( $('input[name="anf_reg_hablaridioma"]:checked').val()==undefined )   { error = 1; $('input[name="anf_reg_hablaridioma"]').addClass('conerror'); }

		if( error == 0){
            this.submit();
        } else {
			alert("Debes completar todos los campos.");
		}
    });

    $('#form_reg_4').on('submit', function(e){
        e.preventDefault();
		$('#anf_reg_quellevar').css('border-bottom','2px solid var(--secondary)');
		$('#mapprof').css('border','2px solid transparent');
		$('.borderError').removeClass('borderError');

		var error = 0 ;
		var errorMsj = '' ;
		if($('#reserva1').is(':checked') && $('.bloqueDia').length==0) {
			error = 1; $('#info_horarios ').css('border','2px solid #F44336');
			errorMsj += '\nSi tu experiencia requiere reserva, debes seleccionar los dias habilitados.';
		} else {
			if($('.bloqueDia').length>0) {
				var sinerror = true;
				$('.bloqueDia').each(function() {
					if($(this).find('input[name="max_personas"]').val()=="") {
						error = 1;
						sinerror = false;
						$(this).find('input[name="max_personas"]').addClass('borderError');
					}
				});
				if(!sinerror) {
					errorMsj += '\nDebes completar la cantidad de personas por turno en todos los casos.';
				}
			}
		}

		if ( $('#coordenadas').val() == "" )   {
			error = 1;
			$('#mapprof').css('border','2px solid #F44336');
			errorMsj += '\nSelecciona en el mapa la ubicación de tu experiencia.';
		}

		if( error == 0){
			$('.bloqueDia').each(function() {
				var diasel = $(this).data('diasel');
				horariosexp[diasel] = new Array();
				$($(this).find('.opcionhorario')).each(function() {
					var horario = $(this).find('select[name="hora"]').val();
					var personas = $(this).find('input[name="max_personas"]').val();
					horariosexp[diasel].push([horario,personas]);
				});
				$('#horariosResv').val(JSON.stringify(horariosexp));
			});
            this.submit();
        } else {
			alert("Se encontraron los siguientes errores:"+errorMsj);
		}
    });

    $('#form_cuenta').on('submit', function(e){
        e.preventDefault();

		$('#numcuenta, #cbu, #alias').css('border-bottom','2px solid var(--secondary)');
		var error = 0 ;

		if ( $("#numcuenta").val() == "" )   { error = 1; $('#numcuenta').css('border-bottom','2px solid #F44336'); }
		if ( $("#cbu").val() == "" )   { error = 1; $('#cbu').css('border-bottom','2px solid #F44336'); }
		if ( $("#alias").val() == "" )   { error = 1; $('#alias').css('border-bottom','2px solid #F44336'); }

		if( error == 0){
            this.submit();
        } else {
			alert("Debes completar todos los campos.");
		}
    });

    $('#formEditExpe').on('submit', function(e){
        e.preventDefault();


		$('#titulo, #descripcion, #precio, #ubicacion, #provincia, #quellevar, #ciudad, input[name="anf_reg_hablaridioma"], #category_selector').css('border-bottom','2px solid var(--secondary)');
		$('#mapprof').css('border','2px solid transparent');
		$('input[name="anf_reg_hablaridioma"]').removeClass('conerror');
		$('.borderError').removeClass('borderError');

		var error = 0 ;
		var errorMsj = '' ;
		if ( $("#titulo").val() == "" )   { error = 1; $('#titulo').css('border-bottom','2px solid #F44336'); }
		if ( $("#descripcion").val() == "" )   { error = 1; $('#descripcion').css('border-bottom','2px solid #F44336'); }
		if ( $("#precio").val() == "" )   { error = 1; $('#precio').css('border-bottom','2px solid #F44336'); }
		if ( $("#ubicacion").val() == "" )   { error = 1; $('#ubicacion').css('border-bottom','2px solid #F44336'); }
		if ( $("#provincia").val() == "X" )   { error = 1; $('#provincia').css('border-bottom','2px solid #F44336'); }
		if ( $("#ciudad").val() == "" )   { error = 1; $('#ciudad').css('border-bottom','2px solid #F44336'); }
		if ( $('input[name="categorias[]"]:checked').length==0 )   { error = 1; $('#category_selector').css('border-bottom','2px solid #F44336'); }


		if($('#reserva1').is(':checked') && $('.bloqueDia').length==0) {
			error = 1; $('#info_horarios ').css('border','2px solid #F44336');
			errorMsj += '\nSi tu experiencia requiere reserva, debes seleccionar los dias habilitados.';
		} else {
			if($('.bloqueDia').length>0) {
				var sinerror = true;
				$('.bloqueDia').each(function() {
					if($(this).find('input[name="max_personas"]').val()=="") {
						error = 1;
						sinerror = false;
						$(this).find('input[name="max_personas"]').addClass('borderError');
					}
				});
				if(!sinerror) {
					errorMsj += '\nDebes completar la cantidad de personas por turno en todos los casos.';
				}
			}
		}

		if ( $('#coordenadas').val() == "" )   {
			error = 1;
			$('#mapprof').css('border','2px solid #F44336');
			errorMsj += '\nSelecciona en el mapa la ubicación de tu experiencia.';
		}

		if( error == 0){
			$('.bloqueDia').each(function() {
				var diasel = $(this).data('diasel');
				horariosexp[diasel] = new Array();
				$($(this).find('.opcionhorario')).each(function() {
					var horario = $(this).find('select[name="hora"]').val();
					var personas = $(this).find('input[name="max_personas"]').val();
					horariosexp[diasel].push([horario,personas]);
				});
				$('#horariosResv').val(JSON.stringify(horariosexp));
			});
            this.submit();
        } else {
			alert("Se encontraron los siguientes errores:"+errorMsj);
		}
    });

	$('#dias_hablitat_cont').on('click', '.btnSacarHorario', function(e) {
		e.preventDefault();
		$(this).closest('tr').remove();
	});


    $('#form_anfitrionreg2').on('submit', function(e){
        e.preventDefault();

		$('#anf_reg_provincia, #anf_reg_ciudad, input[name="anf_reg_hablaridioma"], #anf_reg_cat').css('border-bottom','2px solid var(--secondary)');
		$('input[name="anf_reg_hablaridioma"]').removeClass('conerror');
		var error = 0 ;

		if ( $("#anf_reg_provincia").val() == "X" )   { error = 1; $('#anf_reg_provincia').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_cat").val() == "X" )   { error = 1; $('#anf_reg_cat').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_ciudad").val() == "" )   { error = 1; $('#anf_reg_ciudad').css('border-bottom','2px solid #F44336'); }
		if ( $('input[name="anf_reg_hablaridioma"]:checked').val()==undefined )   { error = 1; $('input[name="anf_reg_hablaridioma"]').addClass('conerror'); }

		if( error == 0){
            this.submit();
        } else {
			alert("Debes completar todos los campos.");
		}
    });


    $('#formPagar').on('submit', function(e){
        e.preventDefault();
        if($('#aceptatyc').is(':checked')) {
            this.submit();
		} else {
			alert("Debes aceptar los términos y condiciones.");
		}
    });

    $('input[name="anf_reg_incluye"]').on('change', function(er) {
		if(this.value!="X") {
			$('#cont_incluye_otro').removeClass('d-none');
		} else {
			$('#cont_incluye_otro').addClass('d-none');
		}
	});



	if ($( "#imageneExpeEdi" ).length>0) {
		$( "#imageneExpeEdi" ).sortable({
			handle: '.movedor',
			cancel: '',
			stop: function( event, ui ) {
				var arrayPos = new Array();
				$('#imageneExpeEdi li').each(function(index ) {
					var reg = new Array(index, $(this).data('proid'));
					arrayPos.push(reg);
				});
				ordenarExpeFotos(arrayPos);
			}
		});
		$( "#imageneExpeEdi" ).disableSelection();
	}

    $('input[name="reserva"]').on('change', function(er) {
		if(this.value=="1") {
			$('#info_horarios').removeClass('d-none');
		} else {
			$('#info_horarios').addClass('d-none');
		}
	});

	$('input[name="anf_reg_idioma[]"]').on('change', function(er) {
		if(this.value==4) {
			if($(this).is(':checked')) {
				$('#cont_anf_reg_idioma').removeClass('d-none');
			} else {
				$('#cont_anf_reg_idioma').addClass('d-none');
				$('#anf_reg_idioma_otro').val("");
			}
		}
	});

    $('input[name="tipo_condicion"]').click(function(e){
		if($(this).val()==1) {
			 $('#form_reg_1').removeClass('d-none');
			 $('#form_reg_0').addClass('d-none');
		} else {
			 $('#form_reg_0').removeClass('d-none');
			 $('#form_reg_1').addClass('d-none');
		}
    });

    $('a.btnSubirFotoDni').click(function(e){
		e.preventDefault();
        $('#fanf_reg_fotodni').click();
    });

    $('a.btnSubirFotoExp').click(function(e){
		e.preventDefault();
        $('#fanf_reg_foto').click();
    });

    $('#form_anfitrionreg3').on('submit', function(e){
        e.preventDefault();

		$('#anf_reg_desc, #anf_reg_email, #anf_reg_nombre, #anf_reg_pass, #anf_reg_pass2').css('border-bottom','2px solid var(--secondary)');
		var error = 0 ;

		if ( $("#anf_reg_desc").val() == "" )   { error = 1; $('#anf_reg_desc').css('border-bottom','2px solid #F44336'); }
		//~ if ( $("#anf_reg_quellevar").val() == "" )   { error = 1; $('#anf_reg_quellevar').css('border-bottom','2px solid #F44336'); }
		if ( ($("#anf_reg_email").val() == "" ) || (!validateEmail($("#anf_reg_email").val())))   { error = 1; $('#anf_reg_email').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_nombre").val() == "" )   { error = 1; $('#anf_reg_nombre').css('border-bottom','2px solid #F44336'); }
		var valpass = validarPass2($("#anf_reg_pass").val(), $("#anf_reg_pass2").val());
		if (!valpass[0]) {
			error = 1; $('#anf_reg_pass').css('border-bottom','2px solid #F44336');
			error = 1; $('#anf_reg_pass2').css('border-bottom','2px solid #F44336');
		}

		if( error == 0){
            this.submit();
        } else {
			var extra = (!valpass[0])?'\n'+valpass[1]:'';
			alert("Debes completar todos loa campos."+extra);
		}
    });

    $('#form_anfitrionreg4').on('submit', function(e){
        e.preventDefault();

		$('#anf_reg_titulo, #anf_reg_desc2, #anf_reg_direccion, #precio').css('border-bottom','2px solid var(--secondary)');
		var error = 0 ;

		if ( $("#anf_reg_titulo").val() == "" )   { error = 1; $('#anf_reg_titulo').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_desc2").val() == "" )   { error = 1; $('#anf_reg_desc2').css('border-bottom','2px solid #F44336'); }
		if ( $("#precio").val() == "" )   { error = 1; $('#precio').css('border-bottom','2px solid #F44336'); }
		if ( $("#anf_reg_direccion").val() == "" )   { error = 1; $('#anf_reg_direccion').css('border-bottom','2px solid #F44336'); }

		if( error == 0){
            this.submit();
        } else {
			alert("Debes completar todos loa campos.");
		}
    });

	$('#dias_hablitat_cont').on('click', '.botonAgregarHorario', function(e) {
		e.preventDefault();
		var quedia = $(this).data('diaexp');
		$('#dias_hablitat_'+quedia+' table').append('<tr class="opcionhorario"><td>'+selectorDias+'</td><td><input name="max_personas" id="max_personas" class="form-control" type="number" value="0"></td><td><a href="#" class="btn btn-secondary btn-sm-super btnSacarHorario"><i class="fa fa-trash"></i></a></td></tr>');
	});


	$('#formEditExpe').on('click','.btnEliminar',function(e){
		e.preventDefault();
		if(confirm('¿Desea eliminar la foto?')) {
			eliminarArchivo('prod', $(this).parent().data('proid'));
			$(this).parent().remove();
		}
	});

	$('.dias_habilit').change(function() {
		var diashab = new Array();
		var diashabSel = new Array();
		$($('.dias_habilit')).each(function() {
			diashab.push($(this).val())
		});
		$($('.dias_habilit:checked')).each(function() {
			diashabSel.push($(this).val())
		});
		for(var i=0;i<diashab.length;i++) {
			if(diashabSel.includes(diashab[i])) {
				if($('#dias_hablitat_cont #dias_hablitat_'+i).length==0) {
					var bloquedia = '<div class="col-md-4 widget-header-item" id="dias_hablitat_'+i+'">'
					+'<div class="bloqueDia panel-body" data-diasel="'+i+'">'
					+'<div class="tituloDia">Dia '+diasesemana[i]+'</div>'
					+' <a href=#" data-diaexp="'+i+'" class="btn btn-success btn-sm-super botonAgregarHorario">Agregar horario</a>'
					+'<div class="selectorHoraDia">'
					+'<table class="table"><thead class="thead-dark"><tr><th class="encabezadoTabla">Hora</th><th class="encabezadoTabla">Max. personas</th><th class="encabezadoTabla"></th></tr></thead><tr class="opcionhorario"><td>'+selectorDias+'</td><td><input name="max_personas" id="max_personas" class="form-control" type="number" value="0"></td><td><a href="#" class="btn btn-secondary btn-sm-super btnSacarHorario"><i class="fa fa-trash"></i></a></td></tr></table>'
					+'</div>'
					+'</div>'
					+'</div>';
					$('#dias_hablitat_cont').append(bloquedia);
				}
			} else {
				$('#dias_hablitat_cont #dias_hablitat_'+i).remove();
			}
		}
	});

    $('.abrirModalShare').click(function(e){
        e.preventDefault();
        $('#compartirUrl').modal("show");
	});

    $('#btnValidarCuponCodigo').click(function(e){
        e.preventDefault();
        var calcod = $('#codigolo').val();
        if(calcod!="") {
			if(calcod.length>4) {
				var data = {};
				data.action = "validarCodigoLote";
				data.calcod = calcod;
				$.ajax({
					dataType: 'json',
					url: apiYeahURL,
					data: data,
					method: 'POST',
					type: 'POST', // For jQuery < 1.9
					success: function (data) {
						if(data.res) {
							$('.bloqueCanjearResultado').html('<div class="alert alert-info">'+data.message+'</div>');
							$('#codigolo').attr('disabled', 'disabled');
						} else {
							$('.bloqueCanjearResultado').html('<div class="alert alert-danger">'+data.message+'</div>');
							setTimeout(function(){
								$('#codigolo').attr('disabled', false);
								$('.bloqueCanjearResultado').html('');
							}, 3000);
						}
					}
				});
			} else {
				alert("El código debe tener 10 caracteres.");
			}
		} else {
			alert("Ingrese un código.");
		}
	});

    $('.bloqueCanjearResultado').on('click', '.btnCanjearCuponCancelar', function(e){
        e.preventDefault();
        $('#codigolo').attr('disabled', false);
        $('#codigolo').val('');
        $('.bloqueCanjearResultado').html('');
	});

    $('.bloqueCanjearResultado').on('click', '.btnCanjearCuponCodigo', function(e){
        e.preventDefault();
        var calcod = $('#codigolo').val();
        if(calcod!="") {
			var data = {};
			data.action = "canjearCodigoLo";
			data.calcod = calcod;
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					if(data.res) {
						$('.bloqueCanjearResultado').html('<div class="alert alert-success resultemp">Código válido y canjeado. Puedes ver la experiencia dentro de tus compras.</div>');
						$('#codigolo').val('');
						$('#codigolo').attr('disabled', false);
						setTimeout(function(){
							$('.bloqueCanjearResultado').html('');
						}, 3000);
					} else {
						$('.bloqueCanjearResultado').append('<div class="alert alert-danger resultemp">'+data.message+'</div>');
						setTimeout(function(){
							$('.bloqueCanjearResultado .resultemp').remove();
							$('#codigolo').attr('disabled', false);
						}, 3000);
					}
				}
			});
		} else {
			alert("Ingrese un código.");
		}
	});


    $('.btnValidarCodigo').click(function(e){
        e.preventDefault();
        var calcod = $('#codigoRed').val();
        if(calcod!="") {
			var exid = $(this).data('exid');
			var data = {};
			data.action = "validarCodigo";
			data.calcod = calcod;
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					if(data.res) {
						$('.bloqueRedimirResultado').html('<div class="alert alert-info">'+data.message+'</div>');
						$('#codigoRed').attr('disabled', 'disabled');
					} else {
						$('.bloqueRedimirResultado').html('<div class="alert alert-danger">'+data.message+'</div>');
						setTimeout(function(){
							$('.bloqueRedimirResultado').html('');
						}, 3000);
					}
				}
			});
		} else {
			alert("Ingrese un código.");
		}
	});

    $('.bloqueRedimirResultado').on('click', '.btnRedimirCancelar', function(e){
        e.preventDefault();
        $('#codigoRed').attr('disabled', false);
        $('#codigoRed').val('');
        $('.bloqueRedimirResultado').html('');
	});

    $('.bloqueRedimirResultado').on('click', '.btnRedimirCodigo', function(e){
        e.preventDefault();
        var calcod = $('#codigoRed').val();
        if(calcod!="") {
			var exid = $(this).data('exid');
			var data = {};
			data.action = "redimirCodigo";
			data.calcod = calcod;
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					if(data.res) {
						$('.bloqueRedimirResultado').html('<div class="alert alert-success">Código válido y redimido.</div>');
						$('#codigoRed').val('');
					} else {
						$('.bloqueRedimirResultado').html('<div class="alert alert-danger">'+data.message+'</div>');
					}
					setTimeout(function(){
						$('.bloqueRedimirResultado').html('');
						$('#codigoRed').attr('disabled', false);
					}, 3000);
				}
			});
		} else {
			alert("Ingrese un código.");
		}
	});

    $('.eliminarFavorito').click(function(e){
        e.preventDefault();
		if(confirm("¿Eliminar favorito?")) {
			if(userLogin) {
				var exid = $(this).data('exid');
				var data = {};
				data.action = "removeFromFavorites";
				data.expid = exid;
				$.ajax({
					dataType: 'json',
					url: apiYeahURL,
					data: data,
					method: 'POST',
					type: 'POST', // For jQuery < 1.9
					success: function (data) {
						if(data.res) {
							$.notify("Eliminado de favoritos", "success");
							$("#expe_fav_"+exid).remove();
						} else {
							$.notify(data.message, "warn");
						}
					}
				});
			} else {
				$("#IniciarSesion").modal('show');
			}
		}
	});

    $('.agregarLikes').click(function(e){
        e.preventDefault();
        var quien = $(this);
        if(!quien.hasClass("agregado")) {
			if(userLogin) {
				var exid = $(this).data('exid');
				var data = {};
				data.action = "addToFavorites";
				data.expid = exid;
				$.ajax({
					dataType: 'json',
					url: apiYeahURL,
					data: data,
					method: 'POST',
					type: 'POST', // For jQuery < 1.9
					success: function (data) {
						if(data.res) {
							$.notify("Agregado a favoritos", "success");
							quien.addClass("agregado");
						} else {
							$.notify(data.message, "warn");
						}
					}
				});
			} else {
				$("#IniciarSesion").modal('show');
			}
		}
	});

    $('.linkCompartir').click(function(e){
        e.preventDefault();
        var titulo = document.title;
        var urlTS = $(this).attr('href');
        var donde = $(this).data('donde');
        shareContent(donde, urlTS, titulo);
	});

    $('.btnEliminarExpe').click(function(e){
        e.preventDefault();
        if(confirmarElimi('esta experiencia')) {
			var quien = $(this);
			var exid = quien.data('exid');
			var data = {};
			data.action = "deleteExper";
			data.expid = exid;
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					if(data.res) {
						quien.parent().parent().remove();
					} else {
						alert(data.message);
					}
				}
			});
		}
	});

    $('#form_anfitrionreg5').on('submit', function(e){
        e.preventDefault();
        $('#fotodnilabel').css('background','transparent');
        $('.btnSubirFotoExp').removeClass('conError');

		var error = 0 ;
		if($('#fanf_reg_foto')[0].files.length==0) {
			error = 1;
			$('.btnSubirFotoExp').addClass('conError');
		}
		if($('#fanf_reg_fotodni')[0].files.length==0) {
			error = 1;
			$('#fotodnilabel').css('background','#f44336');
		}
		if( !registrando && error == 0){
			registrando = true;

            this.submit();
			//~ var data = new FormData();
			//~ $.each($('#fanf_reg_foto')[0].files, function(i, file) {
				//~ data.append('fanf_reg_foto', file);
			//~ });
			//~ $.each($('#fanf_reg_fotodni')[0].files, function(i, file) {
				//~ data.append('fanf_reg_fotodni', file);
			//~ });

			//~ $.each($('#fanf_reg_fotos')[0].files, function(i, file) {
				//~ data.append('fanf_reg_fotos-'+i, file);
			//~ });
			//~ data.append('action', 'nuevoAfitrion');
			//~ data.append('fanf_reg_video', $('#fanf_reg_video').val());

			//~ $('#ftco-loader').addClass('show');

			//~ $.ajax({
				//~ dataType: 'json',
				//~ url: apiYeahURL,
				//~ data: data,
				//~ cache: false,
				//~ contentType: false,
				//~ processData: false,
				//~ method: 'POST',
				//~ type: 'POST', // For jQuery < 1.9
				//~ success: function (data) {
					//~ $('#ftco-loader').removeClass('show');
					//~ if(data.res) {
						//~ $('#MsjGracias').modal('show');
						//~ $('#btnFinalizarPRoc').remove();
						//~ $('#resultadoreg').html('<div class="row mt-5"><div class="col-md-12 mt-2 text-center"><h2 class="mb-1 mt-5">Gracias</h2><p></p><div class="zigzag pb-2 f-none"></div></div></div><div class="row mb-5 mt-5 justify-content-sm-center"><div class="col-sm-4 text-center "><p><a class="btn btn-secondary btn-lg btn-block" href="/">Volver a la Home</a></p></div></div>');
					//~ } else {
						//~ alert(data.message);
					//~ }
				//~ }
			//~ });
        } else {
			alert("Debes completar todos loa campos.");
		}
	});

    $('#btnEnviarcotnacto').click(function(e){
        e.preventDefault();

		$('#nombre, #email, #telefono, #mensaje').css('border-bottom','2px solid var(--secondary)')
		var error = 0 ;

		if ( $("#nombre").val() == "" )   { error = 1; $('#nombre').css('border-bottom','2px solid #F44336'); }
		if ( !validateEmail($("#email").val()) )   { error = 1; $('#email').css('border-bottom','2px solid #F44336'); }
		if ( $("#telefono").val() == "" )   { error = 1; $('#telefono').css('border-bottom','2px solid #F44336'); }
		if ( $("#mensaje").val() == "" )   { error = 1; $('#mensaje').css('border-bottom','2px solid #F44336'); }

		if( error == 0){
			$('#ftco-loader').addClass('show');
			var data = {};
			data.action = "saveContactForm";
			data.nombre = $("#nombre").val();
			data.telefono = $("#telefono").val();
			data.email = $("#email").val();
			data.mensaje = $("#mensaje").val();
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					$('#ftco-loader').removeClass('show');
					if(data.res) {
						$('#resuformcontact').html('<div class="row"><div class="col-md-12 mt-2 text-center"><h2 class="mb-1">Gracias por escribirnos</h2><p></p><div class="zigzag pb-2 f-none"></div></div></div>');
						$('#formcontacto')[0].reset();
						setTimeout(function() {$('#resuformcontact').html('')}, 4000);
					} else {
						alert(data.message);
					}
				}
			});
        } else {
			alert("Debes completar todos los campos.");
		}
    });

    $('#btnEnviarcotnactoEmpresa').click(function(e){
        e.preventDefault();

		$('#nombre, #email, #telefono, #mensaje').css('border-bottom','2px solid var(--secondary)')
		var error = 0 ;

		if ( $("#nombre").val() == "" )   { error = 1; $('#nombre').css('border-bottom','2px solid #F44336'); }
		if ( !validateEmail($("#email").val()) )   { error = 1; $('#email').css('border-bottom','2px solid #F44336'); }
		if ( $("#telefono").val() == "" )   { error = 1; $('#telefono').css('border-bottom','2px solid #F44336'); }
		if ( $("#empresa").val() == "" )   { error = 1; $('#empresa').css('border-bottom','2px solid #F44336'); }
		if ( $("#cantidad_empleados").val() == "" )   { error = 1; $('#cantidad_empleados').css('border-bottom','2px solid #F44336'); }
		if ( $("#mensaje").val() == "" )   { error = 1; $('#mensaje').css('border-bottom','2px solid #F44336'); }

		if( error == 0){
			$('#ftco-loader').addClass('show');
			var data = {};
			data.action = "saveContactFormEmpresa";
			data.nombre = $("#nombre").val();
			data.telefono = $("#telefono").val();
			data.email = $("#email").val();
			data.mensaje = $("#mensaje").val();
			data.empresa = $("#empresa").val();
			data.cantidad_empleados = $("#cantidad_empleados").val();
			$.ajax({
				dataType: 'json',
				url: apiYeahURL,
				data: data,
				method: 'POST',
				type: 'POST', // For jQuery < 1.9
				success: function (data) {
					$('#ftco-loader').removeClass('show');
					if(data.res) {
						$('#resuformcontact').html('<div class="row"><div class="col-md-12 mt-2 text-center"><h2 class="mb-1">Gracias por escribirnos</h2><p></p><div class="zigzag pb-2 f-none"></div></div></div>');
						$('#formcontactoEmpresa')[0].reset();
						setTimeout(function() {$('#resuformcontact').html('')}, 4000);
					} else {
						alert(data.message);
					}
				}
			});
        } else {
			alert("Debes completar todos los campos.");
		}
    });

});



function validateEmail(emailval) {
	var mailformat = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
	if(emailval.match(mailformat)) {
		return true;
	} else 	{
		return false;
	}
}


function validarPass(pass, pass2) {
	var textowarni = '';
	var res = true;

	if(pass=="" || pass2=="") {
		textowarni += '- No debe estar vacia.<br>'
		res = false;
	} else {
		if(pass!=pass2) {
			textowarni += '- Las contraseñas no coinciden.<br>'
			res = false;
		} else {
			// Validate lowercase letters
			var lowerCaseLetters = /[a-z]/g;
			if(!pass.match(lowerCaseLetters)) {
				textowarni += '- Debe contener letras minúsculas.<br>'
				res = false;
			}

			// Validate capital letters
			var upperCaseLetters = /[A-Z]/g;
			if(!pass.match(upperCaseLetters)) {
				textowarni += '- Debe contener letras Mayúsculas.<br>'
				res = false;
			}

			// Validate numbers
			var numbers = /[0-9]/g;
			if(!pass.match(numbers)) {
				textowarni += '- Debe contener al menos un número.<br>'
				res = false;
			}

			// Validate length
			if(pass.length < 8) {
				textowarni += '- Debe contener al menos 8 caracteres .<br>'
				res = false;
			}
		}
	}

	if(!res) {
		textowarni = 'Corrija estos errores de la contraseña:<br>'+textowarni;
		$('#msjregs').append(textowarni);
	}
	return res;
}

function validarPass2(pass, pass2) {
	var textowarni = '';
	var res = true;

	if(pass=="" || pass2=="") {
		textowarni += '- No debe estar vacia.\n'
		res = false;
	} else {
		if(pass!=pass2) {
			textowarni += '- Las contraseñas no coinciden.\n'
			res = false;
		} else {
			// Validate lowercase letters
			var lowerCaseLetters = /[a-z]/g;
			if(!pass.match(lowerCaseLetters)) {
				textowarni += '- Debe contener letras minúsculas.\n'
				res = false;
			}

			// Validate capital letters
			var upperCaseLetters = /[A-Z]/g;
			if(!pass.match(upperCaseLetters)) {
				textowarni += '- Debe contener letras Mayúsculas.\n'
				res = false;
			}

			// Validate numbers
			var numbers = /[0-9]/g;
			if(!pass.match(numbers)) {
				textowarni += '- Debe contener al menos un número.\n'
				res = false;
			}

			// Validate length
			if(pass.length < 8) {
				textowarni += '- Debe contener al menos 8 caracteres .\n'
				res = false;
			}
		}
	}

	if(!res) {
		textowarni = 'Corrija estos errores de la contraseña:\n'+textowarni;
	}
	return [res, textowarni];
}

function isFileImage(file) {
	const acceptedImageTypes = ['image/gif', 'image/jpeg', 'image/png'];

	return file && acceptedImageTypes.includes(file['type'])
}

var thmap;
var marker;
var markers_lu = [];
var markers_g = [];
var apiYeahURL = '/ajax/apiYeah.php';

function initMap() {
	if(latiExp!=0 && longExp!=0) {
		center = new google.maps.LatLng(latiExp, longExp);
		thmap = new google.maps.Map(document.getElementById('mapprof'), {
			zoom: 5,
			center: center
		});
		placeMarker(center);
	} else {
		if(document.getElementById('mapprof')!=null) {
			thmap = new google.maps.Map(document.getElementById('mapprof'), {
				zoom: 5
			});
		}
	}
}

function placeMarker(location) {
	var marker = new google.maps.Marker({
		position: location,
		map: thmap,
		icon: '/images/loc.png'
	});
}

function initMapLugares() {
	center = new google.maps.LatLng(-37.101750613657366,-65.50869005092088);
	thmap = new google.maps.Map(document.getElementById('mapprof'), {
		zoom: 5,
		center: center
	});
	for(var i=0;i<coordmap.length;i++) {
		var por= coordmap[i].split(',')
		center = new google.maps.LatLng(parseFloat(por[0]), parseFloat(por[1]));
		placeMarkerClick(center, coordmap_c[i]);
	}
	var bounds = new google.maps.LatLngBounds();
	for (var i = 0; i < markers_lu.length; i++) {
		bounds.extend(markers_lu[i]);
	}

	thmap.fitBounds(bounds);
}

function placeMarkerNewEx(location) {
	if(markersArray.length>0) {
		clearOverlaysNE();
	}
	var latlng = location.lat()+','+location.lng();
	$('#coordenadas').val(latlng);
	var marker = new google.maps.Marker({
		position: location,
		map: thmap
	});
	markersArray.push(marker);
}
var markersArray = [];
var geocoder;
function initMapNueExpe() {
	center = new google.maps.LatLng(-37.101750613657366,-65.50869005092088);
	thmap = new google.maps.Map(document.getElementById('mapprof'), {
		zoom: 5,
		center: center
	});

	google.maps.event.addListener(thmap, 'click', function(event) {
		placeMarkerNewEx(event.latLng);
	});

	geocoder = new google.maps.Geocoder();

	var address = $('#direccionpaso3').val()+', '+$('#ciudadpaso3').val()+', '+$('#provinciapaso3').val()+', Argentina';
    geocoder.geocode( { 'address': address}, function(results, status) {
      if (status == 'OK') {
        thmap.setCenter(results[0].geometry.location);
        var marker = new google.maps.Marker({
            map: thmap,
            position: results[0].geometry.location
        });
      } else {
        //~ alert('Geocode was not successful for the following reason: ' + status);
      }
    });

}
function initMapEditExpe() {
	center = new google.maps.LatLng(initLat, initLng);
	thmap = new google.maps.Map(document.getElementById('mapprof'), {
		zoom: 12,
		center: center
	});
	google.maps.event.addListener(thmap, 'click', function(event) {
		placeMarkerNewEx(event.latLng);
	});
	placeMarkerNewEx(center)
}
function clearOverlaysNE() {
  for (var i = 0; i < markersArray.length; i++ ) {
	markersArray[i].setMap(null);
  }
  markersArray.length = 0;
}

function placeMarkerClick(location, elid) {
	var marker = new google.maps.Marker({
		position: location,
		map: thmap,
		icon: '/images/loc.png'
	});
	marker.addListener("click", () => {
		putExperiencia(elid);
	});
	markers_lu.push(location);
	markers_g.push(marker);
}

function ponerExpeFiltradasCat(cateid) {
	var expes = [];
	for(var x=0; x<expe_cate.length; x++) {
		for(var y=0; y<expe_cate[x].length; y++) {
			if(expe_cate[x][y].ID==cateid) {
				expes.push(x);
			}
		}
	}
	console.log(expes);
}

function clearOverlays() {
  for (var i = 0; i < markers_g.length; i++ ) {
	markers_g[i].setMap(null);
  }
  markers_g.length = 0;
}

function putExperiencia(eid) {
	if(!isNaN(eid)) {
		$.ajax({
			type: 'POST',
			data: 'action=getExpe&eid='+eid,
			dataType: 'json',
			url: apiYeahURL,
			success: function (data) {
				if(data.res) {
					$('#tituExpe').html(data.data.titulo);
					$('#descExpe').html(data.data.descripcion);
					$('#precioEx').html('$'+data.data.precio);
					$('#linkverMasEx').attr('href','/Experiencias/'+data.data.slug);
					$('#fotoExp').attr('href','/Experiencias/'+data.data.slug);
					$('#fotoExp').css({'background-image':"url(/"+data.data.foto+")"});
					$('#anfi_nombre').html(data.data.anfitrion.nombre);
					$('#anfi_foto').css({'background-image':"url(/"+data.data.anfitrion.foto+")"});
					$('#tituExpe').html(data.data.titulo);
					var estrellas = "";
					for(var er=0;er<5;er++) {
						estrellas += '<span class="estrella-'+((er<data.data.puntn)?'on':'off')+'"></span>';
					}
					$('#estrellasEx').html(estrellas);
					$('#modalExpeL').modal('show');
				} else {
					alert(data.message);
				}
			}
		});
	}
}

function readURL(input, donde) {
	if (input.files && input.files[0]) {
		var reader = new FileReader();

		reader.onload = function (e) {
			$(donde)
				.css('background-image', 'url(' + e.target.result + ')');
		};

		reader.readAsDataURL(input.files[0]);
	}
}

function confirmarElimi(quecosa) {
	var x;
	var r=confirm("¿Realmente desea eliminar "+quecosa+"?");
	return r;
}

function eliminarArchivo(tipo, name) {

	$.ajax({
		url: apiYeahURL,
		type: 'POST',
		dataType: 'json',
		data: 'action=borrarExpeFoto&tipo='+tipo+'&nombre='+name,
		success: function (dataRes) {
			//~ console.log(dataRes);
		}
	});
}



function ordenarExpeFotos(arr) {
	var datos = {};
	datos.action = "ordenarExpeFoto";
	datos.arr = arr;
	 $.ajax({
		type: 'POST',
		dataType: 'json',
		url: apiYeahURL,
		data: datos,
			success: function (data) {
		}
	});
}

function shareContent(donde, url, titulo) {
	var urlShare;
	var ventanCompartir;
	var configuracion_ventana = "menubar=no,location=yes,resizable=yes,scrollbars=yes,status=no,width=600,height=300";
	switch(donde) {
		case "twitter":
			urlShare = "https://twitter.com/intent/tweet?url="+url+"&text="+titulo;
			break;
		case "facebook":
			urlShare = "https://www.facebook.com/sharer/sharer.php?u="+url;
			break;
		case "whatsapp":
			urlShare = "whatsapp://send?text="+url;
			break;
	}

	ventanCompartir = window.open(urlShare, "Compartir: "+titulo, configuracion_ventana);
}
function showDiv() {
    document.getElementById('casaparticular').style.display = "block";
	document.getElementById('casaparticular').style.display = "flex";
 }


$('#icon-lupa').click(function(){
	$('#form-lupa').toggle();
	let h = $('nav.navbar').css('height');
	$('#form-lupa').css('top',h);
});


//////////POPUP////////////

var modal = document.getElementById("myModal");

// Get the button that opens the modal
var btn = document.getElementById("myBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks the button, open the modal
try {
	btn.onclick = function() {
	  modal.style.display = "block";
	}
	
} catch (error) {
	console.log("Button error to open modal");
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
