var cartArray = JSON.parse(localStorage.getItem("cart"));

if(cartArray)
{
    if(cartArray.length === 0) {
        $("#continuar-compra").css("display", "none");
        setTimeout(function () {
            $("#cart-list-expe").html("<h4 id='carrito-empty'>No hay experiencias en el carrito</h4>")
            $("#inner-spinner").css("display", "none");
        }, 4000);
    }
    else
    {
        //console.log(cartArray);
        var experiencias = [];
        //for (let i = 0; i < cartArray.length; i++) {
            $.post("/api/getExperiencia",
            {
                ids: cartArray
            },
            function(data,status){

                for (let i = 0; i < data.Experiencia.length; i++) {
                    experiencias.push(data.Experiencia[i])
                }

            });
        //}

        setTimeout(function (){
            let totalPrice = 0;
            $("#inner-spinner").css("display", "none");
            for (let i = 0; i < experiencias.length; i++) {
                $("#cart-list-expe").append(`
                <div class="container-fluid mt-3">
                    <div class="row">
                        <div class="col-4" style="max-height: 40px; overflow: hidden">
                            <img src="https://yeah.com.ar/storage/experiencias/${experiencias[i].picture}" alt="${experiencias[i].title} foto" class="cart-img" style="width: 100%;max-height: 60px;">
                        </div>
                        <div class="col-8">
                            <h6>${experiencias[i].title}</h6>
                            <p>
                                $ ${experiencias[i].final_price}
                            </p>
                        </div>
                    </div>
                </div>
                `);
                totalPrice = totalPrice + experiencias[i].final_price;
            }
            for (let i = 0; i < experiencias.length; i++) {
                $("#form-cart-buying").append(`
                    <input type="text" style="display: none;" class="form-cart-dinamic-input" value="${experiencias[i].id}" name="${experiencias[i].id}" required />
                `);
            }
            $("#total-cart-div").append(`
                <h5 className="fs-4 black-text" style="text-align: center; margin-top: 1rem" id="totalCart">Total del carrito $ ${totalPrice}</h5>
            `);
        }, 4000)

    }
}
else{
    $("#continuar-compra").css("display", "none");
    setTimeout(function () {
        $("#cart-list-expe").html("" +
            "<h4 id='carrito-empty'>No hay experiencias en el carrito</h4>");
        $("#inner-spinner").css("display", "none");
        cartArray = [];
    }, 4000);
}


function addToCart(id, title, picture, price)
{
    if(cartArray) {
        for (let k = 0; k<cartArray.length; k++)
        {
            if(cartArray[k] == id)
            {
                console.log("Ya existe: ", cartArray[k]);
                $("#alreadyOnCart").css('display', 'block');
                $("#alreadyOnCart").css('opacity', 1);
                setTimeout(function (){
                    $("#alreadyOnCart").css('display', 'none');
                    $("#alreadyOnCart").css('opacity', 0);
                }, 3000)
                return;
            }
        }
        cartArray.push(id);
        localStorage["cart"] = JSON.stringify(cartArray);
        //localStorage.setItem("cart", JSON.stringify(cartArray));

        $("#carrito-empty").html("");
        $("#cart-list-expe").append(`
            <div class="container-fluid mt-3">
                <div class="row">
                    <div class="col-4" style="max-height: 40px; overflow: hidden">
                        <img src="https://yeah.com.ar/storage/experiencias/${picture}" alt=" foto" class="cart-img">
                    </div>
                    <div class="col-8">
                        <h6>${title}</h6>
                        <p>
                            $ ${price}
                        </p>
                    </div>
                </div>
            </div>
        `);
        $("#sidebar-fixed").css("right", "0px");
        $("#form-cart-buying").append(`
            <input type="text" class="form-cart-dinamic-input" style="display: none;" value="${id}" name="${id}" required />
        `);
        $("#continuar-compra").css("display", "block");

        $("#totalCartPrice").remove();
    }
    else
    {
        cartArray.push(id);
        localStorage["cart"] = JSON.stringify(cartArray);
        //localStorage.setItem("cart", JSON.stringify(cartArray));

        $("#carrito-empty").html("");
        $("#cart-list-expe").append(`
            <div class="container-fluid mt-3">
                <div class="row">
                    <div class="col-4" style="max-height: 40px; overflow: hidden">
                        <img src="https://yeah.com.ar/storage/experiencias/${picture}" alt=" foto" style="width: 100%; max-height: 50px;">
                    </div>
                    <div class="col-8">
                        <h6>${title}</h6>
                        <p>
                            $ ${price}

                        </p>
                    </div>
                </div>
            </div>
        `);
        $("#sidebar-fixed").css("right", "0px");
        $("#totalCartPrice").remove();
        $("#form-cart-buying").append(`
            <input type="text" class="form-cart-dinamic-input" style="display: none;" value="${id}" name="${id}" required />
        `);
        $("#continuar-compra").css("display", "block");
    }
}

function clearCart()
{
    $("#carrito-empty").html("");
    $("#cart-list-expe").html("<h4 id='carrito-empty'>No hay experiencias en el carrito</h4>")
    $("#continuar-compra").css("display", "none");
    $(".form-cart-dinamic-input").remove();
    $("#total-cart-div").empty();
    localStorage.clear();
}

function deleteFromCart(id)
{
    if(cartArray)
    {
        if (cartArray.length !== 0)
        {
            for (var i = 0; i < cartArray.length; i++)
            {
                if(cartArray[i] === id)
                {
                    cartArray.splice(i, 1);
                    localStorage["cart"] = JSON.stringify(cartArray);

                }
            }

            location.reload();
        }
    }


}

const cartOpener = document.getElementById("cart-oppener");
$("#cart-oppener").click(function (){
    $("#sidebar-fixed").css("right", "0px");
});

$("#close-cart").click(function () {
    $("#sidebar-fixed").css("right", "-600px");
});

$("#cart-oppener-fixed").click(function (){
    $("#sidebar-fixed").css("right", "0px");
});
