<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Experiencia;
use App\Models\Image;
use App\Models\Place;
use App\Models\Reserva;
use App\Models\Role;
use App\Models\User;
use App\Models\UsersDetail;
use App\Models\Venta;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        //Reserva::factory(1)->create();
        //User::factory(10)->create();

        //$this->command->line('Places...');
        //Place::factory(8)->create();

        
        User::factory(['name'=>'Santiago','email'=>'d@gmail.com','password'=>Hash::make('123'),'role_id'=>1])->create();
        User::factory(['name'=>'Santiago','email'=>'e@gmail.com','password'=>Hash::make('123'),'role_id'=>2])->create();
        User::factory(['name'=>'Santiago','email'=>'f@gmail.com','password'=>Hash::make('123'),'role_id'=>3])->create();
        $this->command->line('Roles...');
        Role::factory(['name'=>'Admin','permits'=>'Alta , baja y modificacion de datos.'])->create();
        Role::factory(['name'=>'Cliente','permits'=>'Compra de experiencias para uso personal y de regalo.'])->create();
        Role::factory(['name'=>'Anfitrion','permits'=>'Alta y modificacion de experiencias, venta de las mismas.'])->create();
        //3: anfitrion, 2: cliente, 1: administrador

        $this->command->line('Experiencias...');
        Experiencia::factory(4)->hasAttached(Category::factory(['title'=>'Deportes'])->create())->create();
        Experiencia::factory(5)->hasAttached(Category::factory(['title'=>'Arte'])->create())->create();
        Experiencia::factory(2)->hasAttached(Category::factory(['title'=>'Al aire libre'])->create())->create();

        //Experiencias y Lugares ESTADOS
        //2: pendiente de aprobacion, 1: Activa, 0: No activa
        $this->command->line('Imagenes...');
        Image::factory(4)->create();

        $this->command->line('Places...');
        Place::factory(8)->create();

        $this->command->line('Clientes...');
        User::factory(['role_id'=>2])->count(10)->create();

        $this->command->line('Anfitriones...');
        User::factory(['role_id'=>3])->count(10)->create();


        $this->command->line('UserDetail ...');
        UsersDetail::factory()->count(5)->create();


        $this->command->line('Preguntas  ...');
        for ($j=0;$j != 5 ; $j++) {
            \App\Models\Pregunta::factory(['experiencia_id'=>$j,'user_id'=>25])->create();
            if($j==3) \App\Models\Pregunta::factory(['experiencia_id'=>$j,'user_id'=>28])->create();
        }

        $this->command->line('Ventas...');
        Venta::factory(6)->create();
    
    }
}
