<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCodigoDescuentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('codigo_descuentos', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->string('discount');
            $table->integer('apply_on_experiencia_id')->nullable(); //null => All
            $table->boolean('used');
            $table->dateTime('date_exp');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('codigo_descuentos');
    }
}
