<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategoriaExperienciaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('categoria_experiencia', function (Blueprint $table) {
            
            $table->id();

            $table->foreignId('experiencia_id')->references('id')->on('experiencias')->constrained()->cascadeOnDelete();
            $table->foreignId('categorie_id')->references('id')->on('categories')->constrained()->cascadeOnDelete();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('categoria_experiencia');
    }
}
