<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCodigoCanjeablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('codigo_canjeables', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->integer('experiencia_id');
            $table->integer('venta_id');
            $table->integer('lote_id')->default(0);
            $table->boolean('used');
            $table->boolean('list_of_codes');
            $table->dateTime('date_exp');
            $table->integer('user_buyer');
            $table->string('user_gifted');
            $table->string('name');
            $table->string('message')->nullable();
            $table->boolean('from_canje')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('codigo_canjeables');
    }
}
