<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExperienciasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('experiencias', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('title_en');
            $table->text('description');
            $table->text('description_en');
            $table->string('picture');
            $table->string('video')->nullable();
            $table->double('price');
            $table->double('final_price');
            $table->string('location');
            $table->string('place');
            $table->string('city');
            $table->string('province');
            $table->string('coordenates');
            $table->integer('main_page');
            $table->string('hours');
            $table->string('includes')->nullable();
            $table->string('languajes');
            $table->integer('must_learn_languaje');
            $table->string('what_bring');
            $table->string('reservation');
            $table->string('extra_indications');
            $table->string('more_about');
            $table->integer('place_id');
            $table->integer('user_id');
            $table->integer('valid');
            $table->integer('require_validation_user')->default(0);
            $table->string('reservations_phone')->nullable();
            $table->string('iva_selector')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('experiencias');
    }
}
