<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users_details', function (Blueprint $table) {
            $table->id();
            //personal info
            $table->string('fake_name');
            $table->string('address');
            $table->string('mobile_phone');
            $table->string('more_information');
            $table->string('host_picture')->nullable();
            //contact info
            $table->string('company_name');
            $table->string('company_type');
            $table->string('company_address');
            $table->string('company_city');
            $table->string('company_province');
            $table->string('reservation_phone');
            //bank and legal data
            $table->integer('responsable_inscripto');
            $table->double('iva_percentaje')->default(21);
            $table->string('cuit');
            $table->string('company_bank')->default('otro');
            $table->string('cbu')->nullable();
            $table->string('alias')->nullable();
            $table->string('mercado_pago_user')->nullable();
            $table->integer('user_id');
            //status
            $table->string('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users_details');
    }
}
