<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\UsersDetail;
use Illuminate\Database\Eloquent\Factories\Factory;

class UsersDetailFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = UsersDetail::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'iva_percentaje'=> '12.25',
            'fake_name'=> $this->faker->name(),
            'address'=> $this->faker->address(),
            'mobile_phone'=> $this->faker->phoneNumber(),
            'more_information'=> $this->faker->realText(20),
            'company_name'=> $this->faker->company(),
            'company_type'=> $this->faker->bs(),
            'company_address'=> $this->faker->address(),
            'company_city'=> $this->faker->city(),
            'company_province'=> $this->faker->state(),
            'reservation_phone'=> $this->faker->phoneNumber(),
            'responsable_inscripto'=> 0,
            'cuit'=> $this->faker->creditCardNumber(),
            'company_bank'=> $this->faker->company(),
            'cbu'=> $this->faker->creditCardNumber(),
            'alias'=> $this->faker->name(),
            'mercado_pago_user'=> $this->faker->userName(),
            'user_id'=> $this->faker->unique()->numberBetween(10, 20),
        ];
    }
}
