<?php

namespace Database\Factories;

use App\Models\Experiencia;
use Illuminate\Database\Eloquent\Factories\Factory;

class ExperienciaFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Experiencia::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $precio=$this->faker->randomDigit();
        $titulo=$this->faker->realText(10);
        $des=$this->faker->text();
        return [
            'title'=>$titulo,
            'title_en'=>$titulo,
            'description'=>$des,
            'description_en'=>$des,
            'picture'=>$this->faker->imageUrl(640, 480, 'experiencia', true),
            'video'=>'www.video.com',
            'price'=>$precio,
            'final_price'=>$precio*1.15,
            'location'=>$this->faker->streetName(),
            'place'=>$this->faker->state(),
            'city'=>$this->faker->city(),
            'province'=>$this->faker->country(),
            'coordenates'=>$this->faker->latitude() . ", " . $this->faker->longitude(),
            'main_page'=>1,
            'hours'=>$this->faker->randomElement(['1 hora','2 horas','3 horas','8 horas','16 horas']),
            'includes'=>$this->faker->randomElement(['Almuerzo','Desayuno','Cena','Almuerzo y desayuno','Almuerzo y cena','Almuerzo , desayuno y cena']),
            'languajes'=>$this->faker->randomElement(['portugues','ingles','español']),
            'must_learn_languaje'=>$this->faker->randomElement([1,2,3]),
            'what_bring'=>'Nada',
            'reservation'=>$this->faker->randomElement(['Sin reserva','Con reserva']),
            'extra_indications'=>'Sin indicaciones extra',
            'more_about'=>'Sin informacion extra',
            'user_id'=>$this->faker->randomElement([1,2,3,4,5,6,7,8,9]),
            'place_id'=>$this->faker->randomElement([1,2,3,4,5,6]),
            'valid'=>1,
        ];
    }
}
