<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

class CategoryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Category::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'title'=>$this->faker->realText(10),
            'description'=>$this->faker->realText(10),
            'picture'=>$this->faker->imageUrl(640, 480, 'experiencia', true),
            'state'=>1,
        ];
    }
}
