<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    use HasFactory;
    protected $fillable = [
        'experiencia_id',
        'user_id',
        'preference_id',
        'amount',
        'completed',
        'approved',
        'quantity',
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function experiencia(){
        return $this->belongsTo(Experiencia::class);
    }

    public function codigoCanjeable()
    {
        return $this->hasOne(CodigoCanjeable::class);
    }
}
