<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'gender',
        'city',
        'phone',
        'province',
        'country',
        'picture',
        'role_id',
        'email_verified_at',
        'state',
        'verified',
        'remember_token',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function role(){
        return $this->belongsTo(Role::class);
    }

    public function UsersDetail()
    {
        return $this->hasOne(UsersDetail::class);
    }

    public function isAdmin(){
        return $this->role_id==1 ? true : false;
    }

    public function calificaciones(){
        return $this->hasMany(Calificacion::class);
    }

    public function experiencias(){
        return $this->hasMany(Experiencia::class);
    }

    public function favoritos(){
        return $this->hasMany(Favorito::class);
    }

    public function ventas(){
        return $this->hasMany(Venta::class);
    }

    public function user_details(){
        return $this->hasOne(UsersDetail::class);
    }

    public function preguntas(){
        return $this->hasMany(Pregunta::class);
    }

    public function reserva(){
        return $this->hasMany(Reserva::class);
    }

    public function califications(){
        return $this->hasMany(Calification::class);
    }
    public function medife_coupons()
    {
        return $this->belongsToMany(CodigoCanjeable::class, 'medife_ase_coupon_user','user_id','codigo_descuento_id');
    }
}
