<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reserva extends Model
{
    use HasFactory;

    protected $table='reservas';
    protected $fillable = [
        'reserva',
        'experiencia_id',
        'user_id',
        'finalizada',
        'blocked_by_anfitrion',
    ];


    public function experiencia()
    {
        return $this->belongsTo(Experiencia::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
