<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pregunta extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'pregunta',
        'respuesta',
        'experiencia_id',
        'user_id',
        'valida_front',
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }
    public function experiencia(){
        return $this->belongsTo(Experiencia::class);
    }
}
