<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PickUp extends Model
{
    use HasFactory;

    protected $fillable = [
        'experiencia_id',
        'user_id',
        'buyer_id',
        'venta_id',
        'email_enviado',
        'retirado',
    ];

    public function experiencia()
    {
        return $this->belongsTo(Experiencia::class);
    }

    public function venta()
    {
        return $this->belongsTo(Venta::class);
    }

    //destinatario
    public function user()
    {
        return $this->belongsTo(User::class, 'buyer_id');
    }
}
