<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Experiencia extends Model
{
    use HasFactory,SoftDeletes;

    protected $table='experiencias';
    protected $fillable = [
        'title',
        'description',
        'title_en',
        'description_en',
        'picture',
        'video',   //nullable
        'price','location','place','city','province','coordenates',
        'main_page','hours',
        'includes', //nullable
        'languajes','must_learn_languaje','what_bring','reservation',
        'reservations_phone',
        'extra_indications','more_about','user_id',
        'place_id','valid','final_price','require_validation_user',
        'iva_selector',
        ];


    public function categories(){
        return $this->belongsToMany(Category::class,'categoria_experiencia','experiencia_id','categorie_id');
    }

    public function allCategoriesNames()
    {
        return $this->categories->pluck('title')->unique();
    }

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function place(){
        return $this->belongsTo(Place::class,'place_id');
    }

    public function favoritos(){
        return $this->hasMany(Favorito::class);
    }

    public function codigos_canjeable(){
        return $this->hasMany(CodigoCanjeable::class);
    }

    public function ventas(){
        return $this->hasMany(Venta::class);
    }

    public function preguntas(){
        return $this->hasMany(Pregunta::class);
    }
    public function images(){
        return $this->hasMany(Image::class);
    }

    public function getPrincipalImage(){
        if($this->images()->get()->isEmpty()){
            return null;
        }

        if(!$this->images()->where('is_principal',true)->first()){
            return $this->images()->firstOrFail();
        }

        return $this->images()->firstOrFail();
    }

    public function reservas()
    {
        return $this->hasMany(Reserva::class,'experiencia_id');
    }

    public function califications()
    {
        return $this->hasMany(Calificacion::class);
    }
    public function allowed_hour()
    {
        return $this->hasOne(AllowedHours::class,'experiencia_id');
    }
}
