<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Envio extends Model
{
    use HasFactory;

    protected $fillable = [
        'direccion',
        'ciudad',
        'provincia',
        'codigo_postal',
        'localidad',
        'experiencia_id',
        'venta_id',
        'user_id',
        'buyer_id',
        'enviado',
        'fecha_envio',
        'email_enviado',
    ];

    public function experiencia()
    {
        return $this->belongsTo(Experiencia::class);
    }

    public function venta()
    {
        return $this->belongsTo(Venta::class);
    }

    //destinatario
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
