<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CodigoCanjeable extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'experiencia_id',
        'used',
        'list_of_codes',
        'date_exp',
        'user_buyer',
        'venta_id',
        'user_gifted',
        'name',
        'message',
        'lote_id',
        'from_canje',
    ];

    public function experiencia(){
        return $this->belongsTo(Experiencia::class);
    }

    public function venta()
    {
        return $this->belongsTo(Venta::class);
    }

    public function lote()
    {
        return $this->belongsTo(LoteCodigo::class, 'lote_id');
    }
}
