<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Calificacion extends Model
{
    use HasFactory;

    protected $table = 'califications';

    protected $fillable = [
        'calification',
        'description',
        'experiencia_id',
        'user_id',
        'validated',
    ];

    public function experiencia()
    {
        return $this->belongsTo(Experiencia::class,'experiencia_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
