<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ExperienciaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required',
            'description' => 'required',
            'price' => 'required',
            'place' => 'required',
            'city' => 'required',
            'province' => 'required',
            'coordenates' => 'required',
            'location' => 'nullable',
            'main_page' => 'required',
            'user_id' => 'required',
            'hours' => 'required',
            'includes' => 'required',
            'must_learn_languaje'=> 'required',
            'what_bring'=> 'required',
            'extra_indications'=> 'nullable',
            'more_about'=> 'nullable',
            'place_id'=> 'required',
            'categorias'=> 'required',
            'español'=> 'nullable',
            'ingles'=> 'nullable',
            'italiano'=> 'nullable',
            'portugues'=> 'nullable',
            'frances'=> 'nullable',
            'aleman'=> 'nullable',
            'main_image' => 'max:2048',

        ];
    }
}
