<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AnfiExperienceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'=> 'required',
            'description'=> 'required',
            'price'=> 'required',
            'hours'=> 'required',
            'includes'=> 'required',
            'extra_indications'=> 'required',
            'what_bring'=> 'required',
            'categorias'=> 'required',
            'picture'=> 'required',
            'city'=> 'required',
            'province'=> 'required',
            'place_id'=> 'required',
            'more_about'=> 'required',
            'location'=> 'required',
            'coordenates'=> 'required',
            'must_learn_languaje'=> 'required',
            'require_validation_user'=> 'required',
            'reservation'=> 'required',
            'cantidad_de_reservas'=> 'present',
            'hora_inicio'=> 'required_if:reservation,==,1',
            //'cantidad_de_dias'=>'required'
        ];
    }
    public function messages()
    {
        return [
            //'cantidad_de_dias.required' => 'No cargaste los dias de tu experiencia',
            'hora_inicio.required' => 'No cargaste el horario de inicio de tu experiencia',
        ];
    }
}
