<?php

namespace App\Http\Controllers;

use App\Models\Favorito;
use App\Models\User;
use App\Models\UsersDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;

class UsersController extends Controller
{
    public function inicio(){
        if (!Auth::check())return redirect('/login');
        $user = Auth::user();
        return view('usuarios.users-home', ['user'=>$user]);
    }

    public function perfil(){
        if (!Auth::check())return redirect('/login');
        $user = Auth::user();
        return view('usuarios.perfil', ['user'=>$user]);
    }

    public function mis_favoritos()
    {
        $user = Auth::user();
        return view('usuarios.mis-favoritos', [
            'user'=>$user,
            'favoritos'=>Favorito::where('user_id', $user->id)->get(),
        ]);
    }
    public function update(Request $request, User $user)
    {
        $validated = $request->validate([
            'name'    => 'nullable',
            'phone'  => 'nullable',
            'province' => 'nullable',
            'city'    => 'nullable',
            'country'      => 'nullable',
            'host_picture' => 'nullable',
            'password' => 'required',
            'password_validation' => 'required'
            
        ]);
        if ($request->password !=$request->password_validation) {
            return view('usuarios.perfil', ['user'=>$user])->withErrors(['msg' => 'Para cambiar tus datos , las contraseñas deben coincidir!']);
        }
    
        
        $user->update($validated);
        
        $anfitrion=UsersDetail::where('user_id',$user->id)->get();
        
        if($request->file('host_picture') and $anfitrion->isNotEmpty()){
            $randomName = Str::random(20) .".".$request->file('host_picture')[0]->extension();
            $request->file('host_picture')[0]->storeAs('public/experiencias', $randomName);
            $anfitrion->first()->host_picture=$randomName;
            
            $anfitrion->first()->save();
            

        }
        return redirect()->route('perfil');
    }
        
}


