<?php

namespace App\Http\Controllers;

use App\Models\Calificacion;
use App\Models\Calification;
use App\Models\CodigoCanjeable;
use App\Models\Experiencia;
use App\Models\Pregunta;
use App\Models\Reserva;
use App\Models\User;
use App\Models\Venta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Exp;

class TuristaController extends Controller
{
    public function mis_reservas()
    {
        $user = Auth::user();
        return view('usuarios.mis_reservas', [
            'reservas'=>Reserva::where('user_id', $user->id)->get(),
            'user'=>$user,
        ]);
    }

    public function mis_codigos()
    {
        $user = Auth::user();
        $codigos = CodigoCanjeable::whereHas('venta', function ($query){
            $user = Auth::user();
            $query->where('user_id', $user->id);
        })
            ->latest()
            ->get();

        return view('usuarios.mis_codigos', [
            'codigos'=>$codigos,
            'user'=>$user,
        ]);
    }

    public function mis_compras()
    {
        $user = Auth::user();

        $compras = Venta::where('user_id', $user->id)
            ->where('approved', 1)
            ->where('completed', 1)
            ->latest()
            ->get();

        /*
        $compras = Venta::whereHas('codigoCanjeable', function ($query){
            $user = Auth::user();
            $query->where('user_gifted', '!=', $user->email);
        })
            ->where('user_id', $user->id)
            ->where('approved', 1)
            ->latest()
            ->get();*/

        //$compras = Venta::where('user_id', $user->id)->latest()->get();
        return view('usuarios.mis_compras', [
            'compras'=>$compras,
            'user'=>$user,
        ]);
    }

    public function mis_canjes()
    {
        $user = Auth::user();

        $compras = Venta::where('user_id', $user->id)
            ->whereHas('codigoCanjeable', function ($query){
                $query->where('from_canje', '=', 1);
            })
            ->where('approved', 1)
            ->latest()
            ->get();

        return view('usuarios.canjes_latam', [
            'compras'=>$compras,
            'user'=>$user,
        ]);
    }

    public function regalos_realizados()
    {
        $user = Auth::user();
        $regalos = CodigoCanjeable::where('user_buyer', $user->id)
            ->where('user_gifted', '!=' ,$user->email)
            ->latest()->get();
        return view('usuarios.regalos_realizados', [
            'regalos'=>$regalos,
            'user'=>$user,
        ]);
    }

    public function regalos_recibidos()
    {
        $user = Auth::user();
        $regalos = CodigoCanjeable::where('user_gifted', $user->email)
            ->where('user_buyer', '!=' ,$user->id)
            ->orderBy('id', 'desc')
            ->get();
        return view('usuarios.regalos_recibidos', [
            'regalos'=>$regalos,
            'user'=>$user,
        ]);
    }

    public function experiencia_detalles($id)
    {
        $user = Auth::user();
        $experiencia = Experiencia::find($id);
        $preguntas = Pregunta::where('experiencia_id', $experiencia->id)
            ->where('valida_front', 1)->latest()
            ->get();
        $lat_long = $experiencia->coordenates;
        $coordenates = explode(", ", $lat_long);

        $compra = CodigoCanjeable::where('user_gifted', $user->email)
            ->where('experiencia_id', $experiencia->id)
            ->where('used', 1)
            ->first();

        if(!$compra){
            return view('experiencias.experiencia', [
                'experiencia'=>$experiencia,
                'coordenates'=>$coordenates,
                'preguntas'=>$preguntas,
            ]);
        }

        if($experiencia != null){
            return view('experiencias.experiencia-detalles', [
                'experiencia'=>$experiencia,
                'coordenates'=>$coordenates,
                'preguntas'=>$preguntas,
            ]);
        }
        else{
            return view('experiencias.not-found');
        }
    }

    public function calificar($id)
    {
        $user = Auth::user();
        $experiencia = Experiencia::find($id);
        if(!$experiencia){
            return view('experiencias.not-found');
        }
        $preguntas = Pregunta::where('experiencia_id', $experiencia->id)
            ->where('valida_front', 1)
            ->get();
        $lat_long = $experiencia->coordenates;
        $coordenates = explode(", ", $lat_long);
        return view('experiencias.experiencia-calificar', [
            'experiencia' => $experiencia,
            'coordenates'=>$coordenates,
            'preguntas'=>$preguntas,
        ]);
    }

    public function storeCalification(Request $request)
    {
        $user = Auth::user();
        $experiencia = Experiencia::find($request->expe_id);
        if(!$experiencia){
            return view('experiencias.not-found');
        }

        $calificacion_existente = Calification::where('user_id', $user->id)
            ->where('experiencia_id', $experiencia->id)
            ->first();

        if($calificacion_existente)
        {
            $preguntas = Pregunta::where('experiencia_id', $experiencia->id)
                ->where('valida_front', 1)
                ->get();
            $lat_long = $experiencia->coordenates;
            $coordenates = explode(", ", $lat_long);

            return view('experiencias.experiencia-calificar', [
                'experiencia' => $experiencia,
                'calificacion_error' => true,
                'coordenates'=>$coordenates,
                'preguntas'=>$preguntas,
            ]);
        }

        $calificacion = new Calification();
        $calificacion->experiencia_id=$request->expe_id;
        $calificacion->stars=$request->stars;
        $calificacion->opinion=$request->opinion;
        $calificacion->user_id=$user->id;
        $calificacion->save();

        $preguntas = Pregunta::where('experiencia_id', $experiencia->id)
            ->where('valida_front', 1)
            ->get();
        $lat_long = $experiencia->coordenates;
        $coordenates = explode(", ", $lat_long);

        return view('experiencias.experiencia-calificar', [
            'experiencia' => $experiencia,
            'calificacion_hecha' => true,
            'coordenates'=>$coordenates,
            'preguntas'=>$preguntas,
        ]);
    }
}
