<?php

namespace App\Http\Controllers;

use App\Models\CodigoCanjeable;
use App\Models\Configuration;
use App\Models\Envio;
use App\Models\Experiencia;
use App\Models\PickUp;
use App\Models\Venta;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use MercadoPago\Item;
use MercadoPago\Preference;
use MercadoPago\SDK;
use App\Http\Controllers\Mailer\Mailer;

class RegalosController extends Controller
{
    public function abrir_regalo_vista()
    {
        $user = Auth::user();
        return view('regalos.canjear-regalo');
    }

    public function abrir_regalo(Request $request)
    {
        $user = Auth::user();
        $codigo_canjeable = CodigoCanjeable::where('code', $request->codigo)
            //->where('user_gifted', $user->id)
            ->where('used', 0)
            ->first();

        if($codigo_canjeable == null)
        {
            return view('regalos.canjear-regalo', [
                'error'=>'No se encontró un regalo con ese código',
            ]);
        }
        $codigo_canjeable->user_gifted = $user->email;
        $codigo_canjeable->save();

        //envio de mails:
        //1 - al comprador

        //2 - al que lo abrio

        $emailBody = '
                <div style="text-align: center;">
                Listo! ¿Viste que es fácil?
                <br>
                Ya abriste tu regalo, ahora te queda hacer la reserva con el/la Anfitrión/a. <br>
                Todos los datos de contacto los viste cuando abriste el Regalo, y se encuentran en tu cuenta de Yeah! en Regalos recibidos.
                <br>
                <br>
                Te dejamos igualemente algunos de sus datos de contacto del Anfitrion
                <br>
                Nombre :'.$codigo_canjeable->experiencia->user->name.'
                <br>
                Correo :'.$codigo_canjeable->experiencia->user->email.'
                <br>
                Telefono :'.$codigo_canjeable->experiencia->user->phone.'
                <br>
                <br>
                <a href="'.route('regalos-recibidos').'"
                style="background-color: #ffc107;
                margin: 5px;
                text-decoration: none;
                padding: 15px !important;
                border: 1px solid #ffc107;;
                color: black;">Ver Regalos</a>
                <br>
                <br>
                <br>
                ¡Qué tengas un lindo día!
                </div>
        ';
        $mail = new Mailer();
        try {
            $mail->sendGiftOpenedMail($codigo_canjeable->user_gifted,
                $emailBody,
                "¡Hola, tenes un regalo!".$user->name." te regaló algo diferente.
                Para saber qué experiencia eligieron para vos, poné este
                código".$codigo_canjeable->code." en nuestra web www.yeah.com.ar
                y abrí tu regalo.");

        } catch (\Throwable $th) {

            return $th;
        }

        return view('regalos.regalo_canjeado', [
            'codigo_canjeable'=>$codigo_canjeable,
        ]);
    }


    public function prepararRegalo($id)
    {
        $user = Auth::user();
        $experiencia = Experiencia::find($id);

        return view('regalos.preparar-regalo', [
            'user'=>$user,
            'experiencia'=>$experiencia,
        ]);
    }

    public function pagarRegalo(Request $request)
    {
        $user = Auth::user();
        $experiencia = Experiencia::find($request->experiencia);
        $costo_envio = Configuration::where('name', 'costo de envio')->first();
        $total = $experiencia->final_price;

        SDK::setAccessToken(config('services.mercadopago.token'));
        $preference = new Preference();

        $item = new Item();
        $item->title = $experiencia->title;
        $item->quantity = 1;
        if($request->tipo_envio == 2) {
            $item->unit_price = $total + $costo_envio->key;
        }
        else{
            $item->unit_price = $total;
        }
        $preference->items = array($item);
        $preference->back_urls = array(
            "success" => url('experiencia-fin-pago-regalo'),
            "failure" => url('experiencia-error-al-comprar'),
            "pending" => url('experiencia-en-espera')
        );
        $preference->auto_return= 'all';
        $preference->redirectMode = 'self';
        $preference->save();

        $venta = new Venta();
        $venta->experiencia_id = $experiencia->id;
        $venta->user_id = $user->id;
        $venta->preference_id = $preference->id;
        $venta->amount = $total;
        $venta->completed = 0;
        $venta->approved = 0;
        $venta->save();

        $codigoCanjeable = new CodigoCanjeable();
        $codigoCanjeable->code = Str::random(10);
        $codigoCanjeable->experiencia_id = $venta->experiencia_id;
        $codigoCanjeable->used = 0;
        $codigoCanjeable->list_of_codes = false;
        $codigoCanjeable->date_exp = Carbon::now()->addDays(90);
        $codigoCanjeable->user_buyer = $user->id;
        $codigoCanjeable->user_gifted = $request->email;
        $codigoCanjeable->venta_id = $venta->id;
        $codigoCanjeable->name = $request->nombre;
        $codigoCanjeable->message = $request->mensaje_para_beneficiario;
        try
        {
            $codigoCanjeable->save();
        }
        catch (\Exception $e)
        {
            $codigoCanjeable->code = Str::random(10);
            $codigoCanjeable->save();
        }
        $precio_envio_postal = 0;
        if($request->tipo_envio == 1){
            //email
        }
        elseif ($request->tipo_envio == 3){
            //pickup
            $pickup = new PickUp();
            $pickup->experiencia_id = $experiencia->id;
            $pickup->buyer_id = $user->id;
            $pickup->user_id = $user->id;
            $pickup->venta_id = $venta->id;
            $pickup->retirado = 0;
        }
        else{
            $envio = new Envio();
            $envio->direccion = $request->direccion;
            $envio->ciudad = $request->ciudad;
            $envio->provincia = $request->provincia;
            $envio->codigo_postal = $request->codigo_postal;
            $envio->localidad = $request->localidad;
            $envio->experiencia_id = $experiencia->id;
            $envio->venta_id = $venta->id;
            $envio->user_id = $user->id;
            $envio->buyer_id = $user->id;
            $envio->enviado = 0;
            $envio->fecha_envio = Carbon::tomorrow();
            $envio->email_enviado = 0;

            $envio->save();
            $total = $total + $costo_envio->key;
            $precio_envio_postal = Configuration::where('name', 'costo de envio')->first()->key;
        }
        return view('regalos.pagar-mercado-pago', [
            'experiencia'=>$experiencia,
            'total'=>$total,
            'preference'=>$preference,
            'precio_envio_postal'=>$precio_envio_postal
        ]);
    }

    public function finCompra()
    {
        $user = Auth::user();
        $venta = Venta::where('user_id', $user->id)->orderByDesc('id')->first();
        $codigoCanjeable = CodigoCanjeable::where('venta_id', $venta->id)->first();
        $pickup = PickUp::where('venta_id', $venta->id)->where('email_enviado', 0)->orderByDesc('id')->first();
        $envio = Envio::where('venta_id', $venta->id)->where('email_enviado', 0)->orderByDesc('id')->first();
        $mail = new Mailer();
        $mail->graciasPorTuCompraEmail(Auth::user()->email, $user->name, $codigoCanjeable->experiencia->title, $codigoCanjeable->experiencia->title);
        if($pickup != null){
            $venta->approved = 1;
            $venta->completed = 1;
            $pickup->email_enviado = 1;
            $pickup->save();
            //enviar emails pick up
            $mail->sendPickUpMail(
                $user->email,
                "
                    <div style='text-align: center;'>
                        <br>
                        Hola, ".$user->name."!
                        <br>
                        <br>
                        Gracias por elegir Yeah.<br>
                        Regalaste esta Experiencia: ".$venta->experiencia->title."<br>
                        <br>
                        <p>Retiros en Centro Pick Up de Sarmiento 155, de Lunes a sabado, de 8 a 12 hs</p>
                        <br>
                        Cualquier consulta escribinos a info@yeah.com.ar.
                        <br>
                        Que tengas un lindo día.
                        <br>
                        <br>
                    </div>
                ",
                "Gracias por tu compra con retiro PickUp. Regalaste esta Experiencia: ".$venta->experiencia->title."<br>
                        Cualquier consulta escribinos a info@yeah.com.ar. <br>Que tengas un lindo día.
                        <p>Retiros en Centro Pick Up de Sarmiento 155, de Lunes a sabado, de 8 a 12 hs</p>");

            $mail->sendEnvioPostalAdmins(
                "
                            <h3>Hola Administrador YeAh!</h3>
                            <p>Un usuario realizó una nueva compra seleccionando el envío retiro en centro pick up,
                            con estos datos de la persona que retira:</p>
                            <br />
								<ul style='list-style-type: none;'>
									<li>Nombre: ".$user->name."</li>
									<li>Email: ".$user->email."</li>
									<li>Código del regalo: ".$codigoCanjeable->code."</li>
								</ul>
								<p>El comprador también adjuntó el siguiente mensaje, para ser entregado al beneficiario:</p>
								<p>".$codigoCanjeable->message."</p><br />
								<p> Los datos del beneficiario son:  </p>
								<p>Nombre: ".$codigoCanjeable->name."</p>
								<p>Email: ".$codigoCanjeable->user_gifted."</p>
								<br>",
                "");
        }
        elseif ($envio != null){
            $venta->approved = 1;
            $venta->completed = 1;
            $envio->email_enviado = 1;
            $envio->save();
            //enviar emails envio postal
            $mail->sendEnvioPostalMail(
                $user->email,
                "
                            <div style='text-align: center;'>
							<br>
							Hola, ".$user->name."!
							<br>
							<br>
							Gracias por elegir Yeah.<br>
							Regalaste esta Experiencia: ".$venta->experiencia->title."<br>
							<br><br>
							<br>
							Cualquier consulta escribinos a info@yeah.com.ar.
							<br>
							Que tengas un lindo día.
							<br>
							<br>
							</div>
                ",
                "Gracias por tu compra con envio postal.Regalaste esta Experiencia: ".$venta->experiencia->title."<br>
                        Cualquier consulta escribinos a info@yeah.com.ar. <br>Que tengas un lindo día.");

            $mail->sendEnvioPostalAdmins(
                "
                            <h3>Hola Administrador YeAh!</h3>
                            <p>Un usuario realizó una nueva compra seleccionando el envío por correo, con estos datos de beneficiario:</p>
                            <br />
								<ul style='list-style-type: none;'>
									<li>Nombre: ".$codigoCanjeable->name."</li>
									<li>Email: ".$codigoCanjeable->user_gifted."</li>
								</ul>
								<ul style='list-style-type: none;'>
									<li>Código del regalo: ".$codigoCanjeable->code."</li>
								</ul>
								<ul style='list-style-type: none;'>
									<li>Dirección: ".$envio->direccion."</li>
									<li>Código Postal: ".$envio->codigo_postal."</li>
									<li>Localidad: ".$envio->localidad."</li>
									<li>Ciudad: ".$envio->ciudad."</li>
									<li>Provincia: ".$envio->provincia."</li>
								</ul>

								<p>El comprador también adjuntó el siguiente mensaje, para ser entregado al beneficiario:</p>
								<p>".$codigoCanjeable->message."</p>

								<p> Los datos de quien envia son:  </p>
								<p>Nombre: ".$user->name."</p>
								<p>Email: ".$user->email."</p>
								<br>",
                "");
        }
        else{
            $venta->approved = 1;
            $venta->completed = 1;

            //enviar email beneficiario
            $result = $mail->sendVirtualGiftMail(
                $codigoCanjeable->user_gifted,
                "¡Hola $codigoCanjeable->name,<br>
                 tenes un regalo!<br>
				".$user->name." te regaló algo diferente.<br>
				Eligió ".$venta->experiencia->title."<br>
                Para conocer más sobre el Anfitrión y hacer tu reserva, poné este código<br>
                <strong>".$codigoCanjeable->code."</strong><br>
                en nuestra web www.yeah.com.ar y abrí tu regalo.<br><br>

				<a href='https://yeah.com.ar/Usuarios/CanjearCupon?codigo_regalo=".$codigoCanjeable->code."'
					style='background-color: #ffc107;margin: 15px;text-decoration: none;padding: 15px !important;
					border: 1px solid #ffc107;color: black;'>Abrir Regalo
                </a>
				<br>
				<br>
				También se incluyó este mensaje:<strong>".$codigoCanjeable->message."</strong>
				<br>
				<br>
                Que tengas un lindo día :)
				<br>",

                "¡Hola, tenes un regalo! ".$user->name." te regaló algo diferente.
                Para saber qué experiencia eligieron para vos, poné este código ".$codigoCanjeable->code." en nuestra web www.yeah.com.ar y abrí tu regalo."
            );
        }
        $venta->save();

        return view('regalos.fin-compra', [
            'venta'=>$venta,
            'user'=>$user,
            'codigoCanjeable'=>$codigoCanjeable,
        ]);
    }

    public function errorEnLaCompra()
    {
        return "Error en el pago!!!";
    }

    public function compraEnEspera()
    {
        $user = Auth::user();
        $venta = Venta::where('user_id', $user->id)
            ->orderByDesc('id')
            ->first();

        return "Pago en espera!!! toda la info de la venta: " . $venta->id;
    }
}
