<?php

namespace App\Http\Controllers;

use App\Models\Experiencia;
use App\Models\Pregunta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PreguntasController extends Controller
{
    public function setPregunta(Request $request)
    {
        $user = Auth::user();

        $pregunta = new Pregunta();
        $pregunta->pregunta = $request->pregunta;
        $pregunta->respuesta = " ";
        $pregunta->experiencia_id = $request->experiencia_id;
        $pregunta->user_id = $user->id;
        $pregunta->valida_front = 0;
        $pregunta->save();

        $experiencia = Experiencia::find($request->experiencia_id);
        $preguntas = Pregunta::where('experiencia_id', $experiencia->id)
            ->where('valida_front', 1)
            ->get();
        $lat_long = $experiencia->coordenates;
        $coordenates = explode(", ", $lat_long);

        if($experiencia != null){
            return view('experiencias.experiencia', [
                'experiencia'=>$experiencia,
                'coordenates'=>$coordenates,
                'preguntas'=>$preguntas,
                'mensaje_pregunta'=>"Muchas gracias por su mensaje. Su consulta será respondida en breve y podrás verla resuelta tu perfil!",
            ]);
        }
        else{
            return view('experiencias.not-found');
        }
    }

    public function misDudas()
    {
        $user = Auth::user();
        $preguntas = Pregunta::whereHas('experiencia', function ($query) {
            $user = Auth::user();
            $query->where('user_id', $user->id);
        })->get();

        return view('usuarios.dudas-pendientes', [
            'user'=>$user,
            'preguntas'=>$preguntas,
        ]);
    }

    public function dudasConsultadas()
    {
        $user = Auth::user();
        $preguntas = Pregunta::where('user_id', $user->id)->get();
        return view('usuarios.dudas-consultadas', [
            'user'=>$user,
            'preguntas'=>$preguntas,
        ]);
    }
}
