<?php

namespace App\Http\Controllers\Mailer;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Mailer
{
    protected $mail;

    public function __construct()
    {
        $this->mail = new PHPMailer(true);
        $this->mail->isSMTP();
        $this->mail->SMTPAuth = true;
        $this->mail->CharSet = "UTF-8";
        $this->mail->Host = "smtp.gmail.com";
        $this->mail->SMTPSecure = 'tsl'; // Activa el cifrado TLS
        $this->mail->Port = 587;
        $this->mail->Username = env('MAIL_USERNAME');
        $this->mail->Password = env('MAIL_PASSWORD');
        $this->mail->FromName = "Yeah! - Comprar y vivir Experiencias";
        $this->mail->From = "info@yeah.com.ar";
    }

    public function sendPickUpMailAdmins($message, $alt_msg)
    {
        $this->mail->addAddress("mariano.palazzini@uosolutions.com", 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Compra con retiro PickUp realizada!';
        $this->mail->Body = view('emails.base_email', ['message'=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendEnvioPostalAdmins($message, $alt_msg)
    {
        $this->mail->addAddress("mariano.palazzini@uosolutions.com", 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Compra con envío postal realizada!';
        $this->mail->Body = view('emails.base_email', ['message'=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }


    public function sendPickUpMail($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Gracias por tu compra con retiro PickUp!';
        $this->mail->Body = view('emails.base_email', ['message'=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendEnvioPostalMail($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo('Hola@gmail.com', 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Gracias por tu compra con envío postal!';
        $this->mail->Body = view('emails.base_email', ['message'=>$message]);
        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    /*public function sendVirtualGiftThanksMail($to, $name, $message, $alt_msg)
    {
        $this->mail->addAddress($to, $name);
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Gracias por tu compra!';
        $this->mail->Body = view('emails.base_email', ['message'=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }*/


    public function graciasPorTuCompraEmail($to, $name, $title)
    {
        $this->mail->addAddress($to, $name);
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = '¡Gracias por tu compra!';
        $this->mail->Body = view('emails.base_email', ['message'=>
            "Hola ".$name."<br>Gracias por elegir Yeah!<br>
            Regalaste esta Experiencia:<br>" .$title.".<br>
            Cualquier consulta escribinos a info@yeah.com.ar.<br>Que tengas un lindo día.<br><br>",
        ]);

        $this->mail->AltBody = "Gracias por elegir Yeah
            Regalaste esta Experiencia: ".$title.".
            Cualquier consulta escribinos a info@yeah.com.ar. Que tengas un lindo día";

        try{
            $this->mail->send();
            $this->mail->ClearAllRecipients();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function enviarRegaloBeneficiarioMail($to, $name, $code, $title, $message, $sender)
    {
        $this->mail->addAddress($to, $name);
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = '¡Hola, tenes un regalo!';
        $this->mail->Body = view('emails.base_email',  ['message'=>
            "¡Hola ".$name.",<br>
            tenes un regalo!<br>
            ".$sender." te regaló algo diferente.<br>
            Eligió ".$title."<br>
            Para conocer más sobre el Anfitrión y hacer tu reserva, poné este código<br>
            <strong>".$code."</strong><br>
            en nuestra web www.yeah.com.ar y abrí tu regalo.<br><br>

            <a href='https://yeah.com.ar/Usuarios/CanjearCupon?codigo_regalo=".$code."'
                style='background-color: #ffc107;margin: 15px;text-decoration: none;
                padding: 15px !important;
                border: 1px solid #ffc107;color: black;'>Abrir Regalo
            </a>
            <br>
            <br>
            También se incluyó este mensaje:<strong>".$message."</strong>
            <br>
            <br>
            Que tengas un lindo día :)
            <br>",
        ]);

        $this->mail->AltBody = "¡Hola, tenes un regalo! ".$sender." te regaló algo diferente.
        Para saber qué experiencia eligieron para vos, poné este código ".$code." en nuestra web www.yeah.com.ar y abrí tu regalo.";
    }

    public function sendVirtualGiftMail($to, $message, $alt_msg)
    {
            $this->mail->addAddress($to, 'Yeah! - Experiencias');
            $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
            $this->mail->isHTML(true);
            $this->mail->Subject = '¡Hola, tenes un regalo!';
            $this->mail->Body = view('emails.base_email',  ['message'=>$message]);

            $this->mail->AltBody = $alt_msg;
        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendGiftOpenedMail($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = '¡Abriste tu regalo!';
        $this->mail->Body = view('emails.base_email',  ['message'=>$message]);

        $this->mail->AltBody = $alt_msg;
        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendCompraConReservaComprador($to, $host, $expe_img, $title, $place, $reservation)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Gracias por tu compra!';
        $this->mail->Body = view("emails.new_base_email", [
            "host"=>$host,
            "expe_img"=>$expe_img,
            "title"=>$title,
            "place"=>$place,
            "reservation"=>$reservation
        ]);

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendCompraConReserva($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Tenes una nueva reserva!';
        $this->mail->Body = view("emails.base_email", ["message"=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendCompraSinReservaCarrito($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Gracias por tu compra! Compraste varias experiencias';
        $this->mail->Body = view("emails.base_email", ["message"=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendCompraSinReserva($to, $subject, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = $subject;
        $this->mail->Body = view("emails.base_email", ["message"=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }



    public function confirmarEnvioFactura($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Se realizó la experiencia - Facturación';
        $this->mail->Body = view("emails.base_email", ["message"=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function calificaLaExperiencia($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Danos tu opinión de la experiencia';
        $this->mail->Body = view("emails.base_email", ["message"=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendResetPasswordMail($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Resetea tu contraseña';
        $this->mail->Body = view("emails.base_email", ["message"=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }

    public function sendRegisterConfirmation($to, $message, $alt_msg)
    {
        $this->mail->addAddress($to, 'Yeah! - Experiencias');
        $this->mail->addReplyTo(env('MAIL_USERNAME'), 'Yeah! - Experiencias');
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Gracias por registrarse';
        $this->mail->Body = view("emails.base_email", ["message"=>$message]);

        $this->mail->AltBody = $alt_msg;

        try{
            $this->mail->send();
            return true;
        }
        catch (\Exception $e)
        {
            return $e;
        }
    }
}
