<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Mailer\Mailer;
use App\Models\Calification;
use App\Models\CodigoCanjeable;
use App\Models\Experiencia;
use App\Models\Favorito;
use App\Models\Pregunta;
use App\Models\Reserva;
use App\Models\User;
use App\Models\Venta;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use MercadoPago\Entity;
use MercadoPago\Item;
use MercadoPago\Preference;
use MercadoPago\SDK;
use PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Exp;

class ExperienciaController extends Controller
{
    public function busqueda(Request $request)
    {
        return ExperienciaController::busqueda_parametrizada($request);
    }


    public function experienciasDelAnfitrion($anfitrion)
    {
        $experiencias = Experiencia::where('user_id', $anfitrion)
            ->where('valid', 1)
            ->paginate(10);

        $anfitrion = User::find($anfitrion);

        return view('experiencias.experiencias-anfitrion', [
            'experiencias'=>$experiencias,
            'anfitrion'=>$anfitrion
        ]);
    }

    public function get_all()
    {
        $experiencias = Experiencia::with('place')
            ->where('valid', 1)
            ->orderBy('id', 'desc')
            ->paginate(10);

        return view('experiencias.busqueda', [
            'experiencias' => $experiencias,
        ]);
    }

    public function marcarFavorita($id)
    {
        $experiencia = Experiencia::find($id);
        if (!$experiencia) {
            return view('not-found');
        }

        $user_id = Auth::user()->id;
        if(Favorito::where('user_id', $user_id)->where('experiencia_id', $experiencia->id)->first())
        {
            return redirect('/mis-favoritos');
        }
        $favorito = new Favorito();
        $favorito->user_id = $user_id;
        $favorito->experiencia_id = $experiencia->id;
        $favorito->save();
        return redirect('/mis-favoritos');
    }

    public function quitarFavorita($id)
    {
        $experiencia = Experiencia::find($id);
        if (!$experiencia) {
            return view('not-found');
        }
        $favorito = Favorito::where('experiencia_id', $id)->first();
        $favorito->delete();
        return redirect('/mis-favoritos');
    }


    public function pagarExperiencia($id, Request $request)
    {
        $user = Auth::user();
        $experiencia = Experiencia::find($id);
        $total = $experiencia->final_price;
        if (!$experiencia) {
            return view('not-found');
        }

        if ($experiencia->reservation == "Con reserva") {
            if (!($request->session()->get('reserva'))) {
                return redirect('/experiencia/' . $experiencia->id . '/reservar');
            }
        }

        SDK::setAccessToken(config('services.mercadopago.token'));
        $preference = new Preference();

        $discount = false;

        if($request->discount != "" || $request->discount != null)
        {
            $discount = true;
        }

        $item = new Item();
        $item->title = $experiencia->title;
        $item->quantity = 1;
        $item->unit_price = $total;
        $preference->items = array($item);
        $preference->back_urls = array(
            "success" => url('experiencia-fin-pago-sin-reserva'),
            "failure" => url('experiencia-error-al-comprar'),
            "pending" => url('experiencia-en-espera')
        );
        $preference->auto_return= 'all';
        $preference->redirectMode = 'self';
        $preference->save();

        $venta = new Venta();
        $venta->experiencia_id = $experiencia->id;
        $venta->user_id = $user->id;
        $venta->preference_id = $preference->id;
        $venta->amount = $total;
        $venta->completed = 0;
        $venta->approved = 0;
        $venta->save();

        return view('experiencias.pagar-experiencia', [
            'experiencia' => $experiencia,
            'total' => $total,
            'preference' => $preference,
            'discount' => $discount,
        ]);
    }

    public function procesarPago(Request $request)
    {
        $user = Auth::user();
        $venta = Venta::where('user_id', $user->id)
            ->orderByDesc('id')
            ->first();

        $venta->completed = 1;
        $venta->approved = 1;
        $venta->save();
        $mail = new Mailer();
        $mail2 = new Mailer();
    
        $reserva = $request->session()->get('reserva');
        if ($reserva) {
            $reserva->save();
            $mail2->sendCompraConReserva(
                $venta->experiencia->user->email,
                "
                <div style='text-align: center;'>
                    <br>
                    ¡Alguien más quiere vivir algo diferente!
                    <br>Eligieron disfrutar la experiencia  ".$venta->experiencia->title.".
                     realizaron una reserva con la fecha: ".$reserva->reserva.".
                    <br>
                    Si entrás a tu cuenta por
                    <a href='https://yeah.com.ar/login'>Acceso a anfitriones </a>
                    vas a encontrar todos los datos guardados en MIS RESERVAS.
                    <br>
                    Si entrás a tu cuenta por
                    <a href='https://yeah.com.ar/login'>Acceso a anfitriones </a>
                    vas a encontrar todos los datos guardados en MIS RESERVAS.
                    <br>
                    ¡Nunca dejes de chequear
                    tu Panel de Reservas!
                    <br>
                    Que tengas un lindo día
                    <br>
                </div>
            ",
                "¡Hola!
                    ¡Alguien más quiere vivir algo diferente!

                    Estimado anfitrión/a, te informamos que un usuario ha comprado
                    tu experiencia " . $venta->experiencia->title . ".

                    ¡Atención! Verificá la compra y la reserva en TUS RESERVAS dentro de tu cuenta.

                    ¡Nunca dejes de chequear
                    tu Panel de Reservas!
                "
            );
        }

        $codigoExistente = CodigoCanjeable::where('venta_id', $venta->id)->first();
        if ($codigoExistente) {
            return redirect('/compras');
        }

        $codigoCanjeable = new CodigoCanjeable();
        $codigoCanjeable->code = Str::random(10);
        $codigoCanjeable->experiencia_id = $venta->experiencia_id;
        $codigoCanjeable->used = 0;
        $codigoCanjeable->list_of_codes = false;
        $codigoCanjeable->date_exp = Carbon::now()->addDays(90);
        $codigoCanjeable->user_buyer = $user->id;
        $codigoCanjeable->user_gifted = $user->email;
        $codigoCanjeable->venta_id = $venta->id;
        $codigoCanjeable->name = $user->name;
        $codigoCanjeable->message = null;
        $codigoCanjeable->save();

          if($reserva){
            $mail->sendCompraConReservaComprador(
                $user->email,
                $venta->experiencia->user->name,
                $venta->experiencia->picture,
                $venta->experiencia->title,
                $venta->experiencia->place,
                $reserva->reserva,
            );
            $request->session()->forget('reserva');
        }
        else{

            $mail->sendCompraSinReserva(
                $user->email, "Gracias por tu compra!",
                "Hola! Gracias por tu compra en Yeah!<br />
                    Para utilizar tu código, llevalo y entregalo al <br />
                    anfitrión de la experiencia, el día que decidas usarlo.<br /><br />
                    <strong>Código de tu compra: " . $codigoCanjeable->code . "</strong>
                    <br /><br />
                    Recorda comunicarte con el anfitrión para arreglar el día, horario y <br />
                    otros detalles de tu experiencia.
                    <br /><br />
                    Si tu compra es con reserva, no necesitas hacer nada más, el anfitrión <br />
                    ya posee todos los datos y la reserva en su sistema.

                    <br /><br />
                    <a style='background-color: #ffc107;
							margin: 5px;
							text-decoration: none;
							padding: 15px !important;
							border: 1px solid #ffc107;;
							color: black;'
                            href='https://yeah.com.ar/login'>Acceder a tu cuenta</a>
                    <br /><br />
                    Que tengas un lindo día.",
                "Hola! Gracias por tu compra en Yeah!<br />
                    Para canjear utilizar tu código, llevalo y entregalo al<br />
                    anfitrión de la experiencia, el día que decidas usarlo.<br />
                    Código de tu compra: ".$codigoCanjeable->code
            );

            $anfitrion = $venta->experiencia->user_id;
            $anfitrion = User::find($anfitrion);
            // Se envia email al anfitrion cuando se compra una de sus experiencia 
            $mail2->sendCompraSinReserva(
                
                $anfitrion->email, "Tenés una venta en YeAh!!",
                "¡Hola!
                ¡Alguien más quiere vivir algo diferente!

                Estimado anfitrión/a, te informamos que un usuario ha comprado
                tu experiencia " . $venta->experiencia->title . ".
                ¡Atención!  Verificá la compra asociado a este Código: ".$codigoCanjeable->code.".

                Si entrás a tu cuenta por Acceso a anfitriones
                <br /><br />
                <a style='background-color: #ffc107;
                        margin: 5px;
                        text-decoration: none;
                        padding: 15px !important;
                        border: 1px solid #ffc107;;
                        color: black;'
                        href='https://yeah.com.ar/login'>Acceder a tu cuenta</a>
                <br /><br />
                Vas a encontrar todos los datos de la Venta en MIS VENTAS.
                <br />
                Te podés comunicar con el usuario con un mensaje por acá:
                <br />
                Nombre y Apellido: ".$user->name." 
                <br/>
                Telefono:".$user->phone."
                <br/>
                Email:".$user->email
                , ""
            );
        }

        return view('experiencias.fin-compra', [
            'venta' => $venta,
            'user' => $user,
            'codigoCanjeable' => $codigoCanjeable,
        ]);
    }

    public function experiencia($id)
    {
        $experiencia = Experiencia::find($id);
        if (!$experiencia) {
            return view('experiencias.not-found');
        }
        $preguntas = Pregunta::where('experiencia_id', $experiencia->id)
            ->where('valida_front', 1)
            ->get();

        $califications = Calification::where('experiencia_id', $experiencia->id)
            ->where('valida_front', 1)
            ->get();

        $lat_long = $experiencia->coordenates;
        $coordenates = explode(", ", $lat_long);

        if ($experiencia) {
            return view('experiencias.experiencia', [
                'experiencia' => $experiencia,
                'califications' => $califications,
                'coordenates' => $coordenates,
                'preguntas' => $preguntas,
            ]);
        }
    }

    public function reservasExperiencia($id)
    {
        $reservas = Reserva::where('experiencia_id', $id)
            ->get();
        $only_dates = $reservas->pluck('reserva');
        return $only_dates;
    }

    public function reservarExperiencia($id)
    {
        $user = Auth::user();
        $experiencia = Experiencia::find($id);
        if (!$experiencia) {
            return view('not-found');
        }
        if ($experiencia->reservation == 0) {
            return redirect('/experiencia/' . $experiencia->id . '/pagar');
        }
        $fechas_reservadas = collect();
        // if (count($experiencia->reservas->pluck('reserva')) > 5) {
        //     $fechas_reservadas->push(date("Y-m-d", strtotime($experiencia->reservas->pluck('reserva')->first())));
        // }
        foreach ($experiencia->reservas->pluck('reserva') as $dia_reservado) {
            $fechas_reservadas->push(date("Y-m-d", strtotime($dia_reservado)));
        }

        return view('experiencias.reservar', [
            'user' => $user,
            'fechas_reservadas' => $fechas_reservadas,
            'experiencia' => $experiencia,
        ]);
    }

    public function chequearReserva(Request $request)
    {
        $user = Auth::user();
        $reserva = Reserva::where('experiencia_id', $request->experiencia)
            ->where('reserva', $request->date . ' ' . $request->hours)
            ->first();

        $expe = Experiencia::find($request->experiencia);


        if ($reserva) {
            return view('experiencias.reservar', [
                'user' => $user,
                'experiencia' => $expe,
                'error' => "La fecha seleccionada posee reservas previas. Por favor, elija otra fecha.",
            ]);
        }
        if (!$expe) {
            return view('errors.404');
        }
        $reserva = new Reserva();
        $reserva->reserva = date("Y-m-d", strtotime($request->date)) . ' ' . $request->hours;
        //$reserva->reserva = $request->date.' '.$request->hours;
        $reserva->experiencia_id = $expe->id;
        $reserva->user_id = $user->id;
        $reserva->finalizada = 0;
        $reserva->blocked_by_anfitrion = 0;

        $request->session()->put(['reserva' => $reserva]);
        return redirect("/experiencia/" . $expe->id . "/pagar");
    }

    public static function busqueda_parametrizada(Request $request)
    {
        $busqueda = $request->get('busqueda');
        switch ($request) {
                //Caso solo categoria
            case $request->category and $request->provincia == null and $request->price == "X":
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)->whereHas('categories', function ($q) use ($request) {
                        $q->where('categories.id', $request->category);
                    })
                    ->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;

                //Caso categoria y lugar
            case $request->category and $request->provincia and $request->price == "X":
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)->whereHas('categories', function ($q) use ($request) {
                        $q->where('categories.id', $request->category);
                    })
                    ->where('province', 'like', "%$request->provincia%")
                    ->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;

                //Caso categoria y precio
            case $request->category and $request->price != "X" and $request->provincia == null:
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)->whereHas('categories', function ($q) use ($request) {
                        $q->where('categories.id', $request->category);
                    })
                    ->whereBetween('final_price', [strstr($request->price, '-', true), str_replace('-', ' ', strstr($request->price, '-'))])
                    ->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;

                //Caso solo lugar
            case $request->provincia and $request->category == null and $request->price == "X":
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)->where('province', 'like', "%$request->provincia%")->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;

                //Caso lugar y precio
            case $request->category == null and $request->provincia and $request->price:
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)->whereBetween('final_price', [strstr($request->price, '-', true), str_replace('-', ' ', strstr($request->price, '-'))])
                    ->where('province', 'like', "%$request->provincia%")
                    ->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;

                //Caso solo precio
            case $request->category == null and $request->provincia == null and $request->price != "X" and $request->price!=null:
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)->whereBetween('final_price', [strstr($request->price, '-', true), str_replace('-', ' ', strstr($request->price, '-'))])
                    ->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;

                //Caso solo titulo
            case $request->busqueda and  $request->category == null and $request->provincia == null and ($request->price == "X" or $request->price==null):
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)->where('title', 'like', "%$busqueda%")
                    ->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;

                //Caso completo
            case $request->category and $request->price and $request->busqueda:
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)
                    ->where('title', 'like', "%$busqueda%")
                    ->whereBetween('final_price', [strstr($request->price, '-', true), str_replace('-', ' ', strstr($request->price, '-'))])
                    ->where('province', 'like', "%$request->provincia%")
                    ->orderBy('id', 'desc')
                    ->whereHas('categories', function ($q) use ($request) {
                        $q->where('categories.id', $request->category);
                    })
                    ->paginate(10);

                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
            default:
                $experiencias = Experiencia::with('place')
                    ->where('valid', 1)
                    ->where('title', 'like', "%$busqueda%")
                    ->whereBetween('final_price', [strstr($request->price, '-', true), str_replace('-', ' ', strstr($request->price, '-'))])
                    ->where('province', 'like', "%$request->provincia%")
                    ->orderBy('id', 'desc')
                    ->whereHas('categories', function ($q) use ($request) {
                        $q->where('categories.id', $request->category);
                    })
                    ->paginate(10);
                return view('experiencias.busqueda', ['experiencias' => $experiencias]);
                break;
        }
    }
}
