<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Experiencia;
use App\Models\Place;
use App\Models\Pregunta;
use Illuminate\Http\Request;

class EnglishController extends Controller
{
    public function home()
    {
        return view('en.welcome',[

            'lugares'=>Place::withCount('experiencias')->where('status', 1)->get()->take(9)->sortBy(function($lugar)
            {
                return $lugar->experiencias->count();
            }),
            'categorias'=>Category::all(),
            'experiencias'=>Experiencia::where('main_page', 1)
                ->orderBy('id', 'desc')
                ->take(10)
                ->get(),
        ]);
    }

    public function experiencia(Experiencia $experiencia)
    {
        if(!$experiencia){
            return view('en.errors.404');
        }
        $preguntas = Pregunta::where('experiencia_id', $experiencia->id)
            ->where('valida_front', 1)
            ->get();
        $lat_long = $experiencia->coordenates;
        $coordenates = explode(", ", $lat_long);

        if($experiencia){
            return view('experiencias.experiencia', [
                'experiencia'=>$experiencia,
                'coordenates'=>$coordenates,
                'preguntas'=>$preguntas,
            ]);
        }
    }
    
}
