<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Mailer\Mailer;
use App\Models\CashDiscountCoupon;
use App\Models\CodigoCanjeable;
use App\Models\CodigoDescuento;
use App\Models\Experiencia;
use App\Models\Venta;
use Carbon\Carbon;
use ErrorException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use MercadoPago\Item;
use MercadoPago\Preference;
use MercadoPago\SDK;

class CartController extends Controller
{
    public function getExperiencia(Request $request)
    {
        return response()->json([
            'Experiencia' => Experiencia::findMany($request->ids)
        ]);
    }

    public function pagarExperiencias(Request $request)
    {
        $user = Auth::user();
        $venta = new Venta();
        $venta->quantity = 0;

        $data = $request->all();
        $total = 0;
        $titulos = "";
        $expe_ids = array();
        foreach ($data as $key => $value) {
            if($key != "_token")
            {
                array_push($expe_ids, $value);
                $experiencia = Experiencia::find($value);
                if($experiencia)
                {
                    if($total == 0)
                    {
                        $titulos = $titulos . " " . $experiencia->title;
                    }
                    else
                    {
                        $titulos = $titulos . ", " . $experiencia->title;
                    }

                    $total = $total + $experiencia->final_price;
                }
                $venta->quantity++;
            }
        }

        Session::push('cart_ids', collect($expe_ids));

        SDK::setAccessToken(config('services.mercadopago.token'));
        $preference = new Preference();

        $item = new Item();
        $item->title = $titulos;
        $item->quantity = 1;
        $item->unit_price = $total;
        $preference->items = array($item);
        $preference->back_urls = array(
            "success" => url('pagar-carrito'),
            "failure" => url('experiencia-error-al-comprar'),
            "pending" => url('experiencia-en-espera')
        );
        $preference->auto_return= 'all';
        $preference->redirectMode = 'self';
        $preference->save();

        $venta->experiencia_id = $experiencia->id;
        $venta->user_id = $user->id;
        $venta->preference_id = $preference->id;
        $venta->amount = $total;
        $venta->completed = 0;
        $venta->approved = 0;
        $venta->save();

        $experiencias = Experiencia::findMany($expe_ids);

        return view('cart.pagar-carrito', [
            'total'=>$total,
            'experiencias'=>$experiencias,
            'preference'=>$preference
        ]);
    }

    public function procesarPagoCarrito(Request $request)
    {
        $user = Auth::user();
        $venta = Venta::where('user_id', $user->id)
            ->orderByDesc('id')
            ->first();

        $venta->completed = 1;
        $venta->approved = 1;
        $venta->save();

        $session_cart=Session::get('cart_ids');

        $experiencias_array = array();

        for($i = 0; $i <count($session_cart[0]); $i++)
        {
            $codigoCanjeable = new CodigoCanjeable();
            $codigoCanjeable->code = Str::random(10);
            $codigoCanjeable->experiencia_id = $session_cart[0][$i];
            $codigoCanjeable->used = 0;
            $codigoCanjeable->list_of_codes = false;
            $codigoCanjeable->date_exp = Carbon::now()->addDays(90);
            $codigoCanjeable->user_buyer = $user->id;
            $codigoCanjeable->user_gifted = $user->email;
            $codigoCanjeable->venta_id = $venta->id;
            $codigoCanjeable->name = $user->name;
            $codigoCanjeable->message = null;
            $codigoCanjeable->save();

            array_push($experiencias_array, $session_cart[0][$i]);
        }
        Session::forget('cart_ids');

        $experiencias = Experiencia::findMany($experiencias_array);
        $mail = new Mailer();
        $expe_titulos = "";
        foreach ($experiencias as $experiencia)
        {
            $expe_titulos .= "<strong>" . $experiencia->title . "</strong><br />";
        }
        $mail->sendCompraSinReservaCarrito($user->email,
            "Hola! Gracias por comprar experiencias en Yeah!<br />
                    <br /><br />
                    ".$expe_titulos."
                    <br /><br />
                    Para utilizar tus códigos, llevalos y entregalos al <br />
                    anfitrión de cada experiencia, el día que decidas usarlo.<br /><br />
                    <br /><br />
                    Recorda comunicarte con el anfitrión para arreglar el día, horario y <br />
                    otros detalles de tu experiencia.
                    <br /><br />
                    Podes encontrar el código de las experiencias que compraste en la sección
                    Ver mis códigos:
                    <br /><br />
                    <a style='background-color: #ffc107;
							margin: 5px;
							text-decoration: none;
							padding: 15px !important;
							border: 1px solid #ffc107;;
							color: black;'
                            href='https://yeah.com.ar/login'>Mis códigos</a>
                    <br /><br />
                    Que tengas un lindo día.",
            "Hola! Gracias por tu compra en Yeah!<br />
                    Para utilizar tus códigos, llevalos y entregalos al<br />
                    anfitrión de la experiencia, el día que decidas usarlo.<br />
                    Tus códigos: <a href='https://yeah.com.ar/mis_codigos'>Mis códigos</a>"
        );

        return view('cart.cart-success', [
            'user'=>$user,
            'experiencias'=>$experiencias
        ]);
    }
    public function validarDescuento(Request $request)
    {
        $code_discount= CodigoDescuento::where('code',$request->code_discount)->first();
        if (!$code_discount) {
            $cash_discount = CashDiscountCoupon::where('code', $request->code_discount)->first();
            if($cash_discount)
            {
                $experiencia=Experiencia::find($request->experience_id);
                $total = $experiencia->final_price - $cash_discount->amount;

                SDK::setAccessToken(config('services.mercadopago.token'));
                $preference = new Preference();

                $item = new Item();
                $item->title = $experiencia->title;
                $item->quantity = 1;
                $item->unit_price = $total;
                $preference->items = array($item);
                $preference->back_urls = array(
                    "success" => url('experiencia-fin-pago-sin-reserva'),
                    "failure" => url('experiencia-error-al-comprar'),
                    "pending" => url('experiencia-en-espera')
                );
                $preference->auto_return= 'all';
                $preference->redirectMode = 'self';
                $preference->save();

                Venta::create([
                    'experiencia_id' => $experiencia->id,
                    'user_id' =>Auth::id(),
                    'preference_id' => $preference->id,
                    'amount' => $total,
                    'completed' => 0,
                    'approved' => 0
                ]);

                return view('experiencias.pagar-experiencia', [
                    'experiencia' => $experiencia,
                    'total' => $total,
                    'preference' => $preference,
                    'success' =>'Codigo aplicado!',
                    'code'=>$cash_discount->code,
                ]);

            }
            return Redirect::back()->withErrors(['msg' =>'Codigo invalido']);
        }

        $duplicate_use=DB::table('medife_ase_coupon_user')->where('user_id', Auth::id())->where('codigo_descuento_id',$code_discount->id)->get();
        if(count($duplicate_use)!=0)return Redirect::back()->withErrors(['msg' =>'Ya usaste ese codigo, lo sentimos! ']);

        $experiencia=Experiencia::find($request->experience_id);

        if ($code_discount->apply_on_experiencia_id!=null and $code_discount->apply_on_experiencia_id != $experiencia->id ) return Redirect::back()->withErrors(['msg' =>'Codigo invalido para esta experiencia']);

        $code_discount->users()->attach(Auth::user());
        if($code_discount->discount > 9 ) $total=$experiencia->final_price-$experiencia->final_price*('0.'.$code_discount->discount);
        if($code_discount->discount <= 9 ) $total=$experiencia->final_price-$experiencia->final_price*('0.0'.$code_discount->discount);

        SDK::setAccessToken(config('services.mercadopago.token'));
        $preference = new Preference();

        $item = new Item();
        $item->title = $experiencia->title;
        $item->quantity = 1;
        $item->unit_price = $total;
        $preference->items = array($item);
        $preference->back_urls = array(
            "success" => url('experiencia-fin-pago-sin-reserva'),
            "failure" => url('experiencia-error-al-comprar'),
            "pending" => url('experiencia-en-espera')
        );
        $preference->auto_return= 'all';
        $preference->redirectMode = 'self';
        $preference->save();

        Venta::create([
                'experiencia_id' => $experiencia->id,
                'user_id' =>Auth::id(),
                'preference_id' => $preference->id,
                'amount' => $total,
                'completed' => 0,
                'approved' => 0
        ]);

        return view('experiencias.pagar-experiencia', [
            'experiencia' => $experiencia,
            'total' => $total,
            'preference' => $preference,
            'success' =>'Codigo aplicado!',
            'code'=>$code_discount->code
        ]);
    }
}
