<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Mailer\Mailer;
use App\Models\Category;
use App\Models\Experiencia;
use App\Models\Image;
use App\Models\Place;
use App\Models\User;
use App\Models\UsersDetail;
use Exception;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'gender' => $request->gender,
            'city' => $request->city,
            'province'=>$request->province,
            'country' => $request->country,
            'phone'=> $request->phone,
            'role_id'=>2,
            'state'=>1,
            'verified'=>0
        ]);

        $mail = new Mailer();

        $mail->sendRegisterConfirmation(
            $user->email,
            "<div style='text-align: center'>
                        <br>
                        Hola ".$user->name."!, <br>
                        <br>
                        Gracias por registrarte en Yeah.<br>
                        Ya puedes comenzar a comprar experiencias
                        para vos o para regalar a tus amigos o
                        familia.<br>
                        <br>
                        <br>
                        <a href='https://yeah.com.ar'
                            style='background-color: #ffc107;
                            margin: 5px;
                            text-decoration: none;
                            padding: 15px !important;
                            border: 1px solid #ffc107;
                            color: black;'>Ir a YeAh!</a>
                        <br>
                        <br>
					</div>",
            "",
        );

        event(new Registered($user));

        Auth::login($user);

        return redirect('/');
    }

    public function previoRegistro()
    {
        return view('auth.register-anfitrion');
    }


    //GET STEPPER

    public function createAnfitriones()
    {
        return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso1');
    }
    public function createAnfitrionesPaso2(User $user)
    {
        return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso2', ['user'=>$user]);
    }
    public function createAnfitrionesPaso3()
    {
        return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso3',['categorias'=>Category::all(),'lugares'=>Place::all()]);
    }
    public function createAnfitrionesPaso4()
    {
        return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso4');
    }
    public function createAnfitrionesPaso5()
    {
        return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso5');
    }
    public function createAnfitrionesSucess()
    {
        return view('auth.stepper.Anfitrion-Fisico.FinStepper');
    }

    //POST STEPPER
    public function storeAnfitrionesFisicosStep1(Request $request)
    {
        $validated=$request->validate([
            'nombre' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required',
            'genero'=> 'required',
            'localidad'=> 'required',
            'provincia'=> 'required',
            'celular'=> 'required',
            'password2' => 'required',
            'fake_name' => 'required',
            'address'=> 'required',
            'responsable_insc'=> 'required',
            'cuit'=> 'required',
        ]);

        $uppercase = preg_match('@[A-Z]@', $request->password);
        $lowercase = preg_match('@[a-z]@', $request->password);
        $number    = preg_match('@[0-9]@', $request->password);

        if(!$uppercase || !$lowercase || !$number) {
            return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso1')->withErrors(['msg' => 'La contraseña debe incluir una mayúscula y al menos un caracter alfanumérico!']);
        }

        if($request->password != $request->password2){
            return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso1')->withErrors(['msg' => 'Las contraseñas no coinciden!']);
        }

        $user = User::create([
            'name' => $request->nombre . " " . $request->apellido,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'gender' => $request->genero,
            'city' => $request->localidad,
            'province' => $request->provincia,
            'phone' => $request->celular,
            'country' => "Argentina",
            'picture' => 'user-generic.png',
            'role_id' => 3,
            'state' => 0,
            'verified' => 0,
        ]);
        UsersDetail::create($validated+[
            'status'=>2,
            'fake_name'=>$request->fake_name,
            'user_id'=>$user->id,
            'iva_percentaje'=>21,
            'mobile_phone'=>$request->celular,
            'reservation_phone'=>$request->celular,
            'more_information'=>'Anfitrion creado atravez de la pagina',
            'responsable_inscripto'=>$request->responsable_insc,
            'company_name'=>'No cargado',
            'company_type'=>'No cargado',
            'company_address'=>'No cargado',
            'company_city'=>'No cargado',
            'company_province'=>'No cargado'
        ]);

        return redirect()->route('registro-anfitriones-fisico.paso-2',['user'=>$user]);
    }

    public function storeAnfitrionesFisicosStep2(Request $request)
    {
        $validated=$request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|max:255',
            'includes' => 'required',
            'price'=> 'required',
            'phone'=> 'required'
        ]);

        if(empty($request->session()->get('experiencia'))){
            $experiencia = new Experiencia($validated);
            $request->session()->put(['experiencia'=>$experiencia]);

        }else{
            $experiencia = $request->session()->get('experiencia');
            $request->session()->put(['experiencia'=>$experiencia]);
        }
        return redirect()->route('registro-anfitriones-fisico.paso-3');

    }
    public function storeAnfitrionesFisicosStep3(Request $request)
    {
        $experiencia = $request->session()->get('experiencia');

        $validated=$request->validate([
            'place' => 'required',
            'province' => 'required',
            'coordenates' => 'required',
            'city' => 'required',
            'categorias'=> 'required',
            'extra_indications'=> 'required',
            'require_validation_user'=> 'required'
        ]);

        if(Place::where('name',$request->place)->get()->first()){
            $place=Place::where('name',$request->place)->get()->first();
        }
        else{
        $place=new Place([
            'name'=>$request->place.' , '.$request->city,
            'image'=>'place-generic.png',
            'status'=>0,
        ]);
        }

        $categorias=collect();
        foreach ($request->categorias as $categoria_id) {
            $categorias->push(Category::find($categoria_id));
        }
        $languajes = "";
        if($request->español == 'español')$languajes .= ' Español ';
        if($request->ingles == 'ingles')$languajes .= ' Ingles ';
        if($request->italiano == 'italiano')$languajes .= ' Italiano ';
        if($request->portugues == 'portugues')$languajes .= ' Portugues ';
        if($request->frances == 'frances')$languajes .= ' Frances ';
        if($request->aleman == 'aleman')$languajes .= ' Aleman ';

        $experiencia->place=$request->place;
        $experiencia->province=$request->province;
        $experiencia->city=$request->city;
        $experiencia->extra_indications=$request->extra_indications;
        $experiencia->require_validation_user=$request->require_validation_user;
        $experiencia->languajes=$languajes;
        //Le saco los parentesis y el espacio que viene el el location de Google maps (seguro lo puedo juntar en 1 linea)
        $request->coordenates=str_replace('(', '', $request->coordenates);
        $request->coordenates=str_replace(')', '', $request->coordenates);
        // $request->coordenates=str_replace(' ', '', $request->coordenates);
        $experiencia->coordenates=$request->coordenates;


        $request->session()->put(['experiencia'=>$experiencia]);
        $request->session()->put(['categorias'=>$categorias]);
        $request->session()->put(['place'=>$place]);

        return redirect()->route('registro-anfitriones-fisico.paso-4');
    }

    public function storeAnfitrionesFisicosStep4(Request $request)
    {

        $validated=$request->validate([
            'what_bring' => 'required',
            'reservation' => 'required',]);

        $experiencia = $request->session()->get('experiencia');

        $experiencia->what_bring=$request->what_bring;
        $request->reservation ==0 ? $experiencia->reservation='Sin reserva' : $experiencia->reservation='Con reserva';

        $request->session()->put(['experiencia'=>$experiencia]);


        return redirect()->route('registro-anfitriones-fisico.paso-5');
    }

    public function storeAnfitrionesFisicosStep5(Request $request)
    {
        $experiencia = $request->session()->get('experiencia');
        $categorias = $request->session()->get('categorias');
        $place = $request->session()->get('place');


        try {
            DB::transaction(function () use ($categorias,$request,$experiencia,$place) {

                $main_image = new Image;
                $randomName = Str::random(20) .".".$request->file('main_image')[0]->extension();
                $main_image->url_image=$randomName;
                $request->file('main_image')[0]->storeAs('public/experiencias', $randomName);
                $main_image->name="Imagen principal";
                $place->save();

                $experiencia->valid=0;
                $experiencia->final_price=round($experiencia->price*1.15/10)*10;
                $experiencia->video=$request->video ? $request->video : null;
                $experiencia->picture=$main_image->url_image;


                //Todos esta datos estan faltando
                $experiencia->location=$experiencia->place;
                $experiencia->main_page=0;
                $experiencia->hours="0 horas";
                $experiencia->must_learn_languaje=0;
                $experiencia->more_about="";
                $experiencia->place_id=$place->id;
                $experiencia->user_id=User::find(1)->id;



                $experiencia->save();
                $main_image->experiencia_id = $experiencia->id;
                $main_image->save();

                foreach ($categorias as $categoria) {
                    $experiencia->categories()->sync($categoria, false);
                }
                if($request->file('extra_images')){
                    foreach($request->file('extra_images') as $file){
                        $image = new Image;
                        $randomName = Str::random(20) .".". $file->extension();
                        $image->url_image=$randomName;
                        $file->storeAs('public/experiencias', $randomName);
                        $image->name="Imagen subida";
                        $image->experiencia_id=$experiencia->id;
                        $image->save();
                    }
                }
            });
            return redirect()->route('registro-anfitriones-fisico.fin');
        }
        catch(Exception $e){
            return($e);
        }
    }



    public function createAnfitrionesJuridicoStep2(Request $request)
    {


        $validated=$request->validate([
            'emp_razon_social' => 'required|string|max:255',
            'emp_cuit' => 'required|string|max:255',
            'fake_name' => 'required|string|max:255',
            'emp_telefono' => 'required',
            'emp_direccion' => 'required',
            'emp_provincia'=> 'required',
            'emp_ciudad'=> 'required',
            'nombre'=> 'required',
            'apellido'=> 'required',
            'celular' => 'required',
            'anf_reg_email' => 'required|email',
            'anf_reg_pass'=> 'required',
            'anf_reg_pass2'=> 'required',
            'reserva'=> 'required',

        ]);

    if($request->anf_reg_pass != $request->anf_reg_pass2){
        return view('auth.stepper.Anfitrion-Fisico.register-anfitrion-paso1')->withErrors(['msg' => 'Las contraseñas no coinciden!']);
    }

        $user = User::create([
            'name' => $validated['nombre']. " " . $validated['apellido'],
            'email' => $validated['anf_reg_email'],
            'password' => Hash::make($validated['anf_reg_pass']),
            'gender' => 'No definido por ser persona juridica',
            'city' => 'No definido por ser persona juridica',
            'province' => 'No definido por ser persona juridica',
            'phone' => $validated['celular'],
            'country' => "No definido por ser persona juridica",
            'picture' => 'user-generic.png',
            'role_id' => 3,
            'state' => 0,
            'verified' => 0,
        ]);


        UsersDetail::create($validated+[
            'status'=>2,
            'fake_name'=>$validated['fake_name'],
            'user_id'=>$user->id,
            'address'=>$validated['emp_direccion'],
            'iva_percentaje'=>21,
            'cuit'=>$validated['emp_cuit'],
            'mobile_phone'=>$validated['emp_telefono'],
            'reservation_phone'=>$validated['celular'],
            'more_information'=>'Anfitrion creado atravez de la pagina',
            'responsable_inscripto'=>$validated['reserva'],
            'company_name'=>$validated['emp_razon_social'],
            'company_type'=>'No cargado',
            'company_address'=>$validated['emp_direccion'],
            'company_city'=>$validated['emp_ciudad'],
            'company_province'=>$validated['emp_provincia']

        ]);

        return redirect()->route('registro-anfitriones-fisico.paso-2',['user'=>$user]);
    }
}
