<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Password;
use App\Http\Controllers\Mailer\Mailer;

class PasswordResetLinkController extends Controller
{
    /**
     * Display the password reset link request view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.forgot-password');
    }

    /**
     * Handle an incoming password reset link request.
     *
     * @param  \Illuminate\Http\Request  $request
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ]);

        // We will send the password reset link to this user. Once we have attempted
        // to send the link, we will examine the response then see the message we
        // need to show to the user. Finally, we'll send out a proper response.

        $mail = new Mailer();

        $token = Str::random(10);

        $email_enviado = $mail->sendResetPasswordMail(
            $request->email,
            "Has solicitado un cambio de contraseña.<br>
             Para realizar un cambio en tu contraseña, por favor, hace click en el boton<br>
             que se encuentra debajo, donde podrás especificar tu nueva password.
             <br><br>
             <a href='".env('APP_URL')."reset-password/".$token."'
                style='background-color: #ffc107;
                margin: 10px;
                text-decoration: none;
                padding: 15px !important;
                border: 1px solid #ffc107;;
                color: black;'>Cambiar password</a>
             <br><br>",
            "");

            $user = User::where('email', $request->email)->first();
            $user->remember_token = $token;
            $user->save();

            if($email_enviado){
                return view('auth.forgot-pass-email');
            }
            else{
                return view('auth.forgot-pass-email-wrong');
            }

        /*$status = Password::sendResetLink(
            $request->only('email')
        );

        return $status == Password::RESET_LINK_SENT
                    ? back()->with('status', __($status))
                    : back()->withInput($request->only('email'))
                            ->withErrors(['email' => __($status)]);*/
    }
}
