<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Mailer\Mailer;
use App\Http\Requests\AnfiExperienceRequest;
use App\Models\AllowedHours;
use App\Models\Category;
use App\Models\CodigoCanjeable;
use App\Models\Experiencia;
use App\Models\Image;
use App\Models\Place;
use App\Models\Reserva;
use App\Models\User;
use App\Models\Venta;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Str;
use function PHPUnit\Framework\isNull;

class AnfitrionController extends Controller
{
    public function mis_ventas(){
        $user = Auth::user();
        $ventas = Venta::whereHas('experiencia', function ($query) use ($user) {
            $query->where('user_id', '=', $user->id)
                  ->whereNull('deleted_at'); // Filtra experiencias no eliminadas
        })
        ->whereHas('codigoCanjeable', function ($query) {
            $query->where('used', '=', 1)
                  ->where('user_gifted', '=', function ($subquery) {
                      return $subquery->select('email')
                                      ->from('users')
                                      ->whereColumn('users.id', 'ventas.user_id');
                  });
        })
        ->where('completed', 1)
        ->where('approved', 1)
        ->orderBy('created_at', 'desc')
        ->get();
        
        return view('anfitriones.mis-ventas', [
            'ventas'=>$ventas,
            'user'=>$user,
        ]);
    }

    public function mis_reservas(){
        $user = Auth::user();

        $reservas = Reserva::whereHas('experiencia', function ($query) use ($user) {
            return $query->where('user_id',$user->id);
        })->latest()->get();

        return view('anfitriones.mis-reservas',['user'=>$user,'reservas'=>$reservas]);
    }

    public function bloquearHorario(Experiencia $experiencia)
    {
        $horarios_bloqueados = AllowedHours::where('experiencia_id', $experiencia->id)->first();
        return view('anfitriones.bloquear-horario',[
            'user'=>Auth::user(),
            'experiencia'=>$experiencia,
            'horarios_bloqueados'=>$horarios_bloqueados,
        ]);
    }

    public function bloquearFecha()
    {
        $user = Auth::user();
        $experiencias=Experiencia::with('user')->where('user_id',$user->id)->get();

        return view('anfitriones.bloquear-fecha',[
            'user'=>$user,
            'experiencias'=>$experiencias
        ]);
    }

    public function bloquearHorarioPost(Experiencia $experiencia,Request $request)
    {
        $dias_laborales=collect();
        foreach ($request->dias_laborales as $dia_laboral) {
            $dias_laborales->push($dia_laboral);
        }

        AllowedHours::updateOrCreate([
            'experiencia_id'=>$experiencia->id],
            [
            'dias_laborales'=>$dias_laborales->implode('-'),
            'cantidad_de_reservas'=>(int)$request->cantidad_de_reservas,
            'hora_desde'=>$request->hora_inicio,
            'hora_hasta'=>$request->hora_fin
        ]);
        return redirect()->route('mis-experiencias')->withErrors(['msg' => 'Horario asignado para '.$experiencia->title]);
    }

    public function bloquearCodigoPost(Request $request)
    {
        $experiencia=Experiencia::findOrFail($request->experiencia_id);
        foreach ($experiencia->reservas as $reserva) {
            if ($reserva==$request->fecha_a_bloquear) {
                return redirect()->route('bloquear-fecha')->withErrors("La fecha ya posee una reseva");
            }
        }
        Reserva::create([
                'reserva'=>$request->fecha_a_bloquear,
                'experiencia_id'=>$request->experiencia_id,
                'user_id'=>Auth::user()->id,
                'finalizada'=>0,
                'blocked_by_anfitrion'=>1
        ]);

        return view('anfitriones.bloquear-fecha-exito',[
            'user'=>Auth::user(),
            'fecha'=>$request->fecha_a_bloquear,
            'experiencia'=>Experiencia::find($request->experiencia_id),
        ]);
    }

    public function editar_experiencia($id){
        $user = Auth::user();
        $experiencia = Experiencia::findOrFail($id);
        if($experiencia->user_id != $user->id){
            return redirect('/');
        }
        return view('anfitriones.editar-expe', [
            'experiencia'=>$experiencia,
            'user'=>$user,
            'categorias'=>Category::all(),
            'places'=>Place::all(),
        ]);
    }

    public function guardar_experiencia_editada(Request $request)
    {
        $user = Auth::user();

        $experiencia = Experiencia::find($request->expe_id);

        $languajes = "";
        if($request->español == 'español')$languajes .= ' Español ';
        if($request->ingles == 'ingles')$languajes .= ' Ingles ';
        if($request->italiano == 'italiano')$languajes .= ' Italiano ';
        if($request->portugues == 'portugues')$languajes .= ' Portugues ';
        if($request->frances == 'frances')$languajes .= ' Frances ';
        if($request->aleman == 'aleman')$languajes .= ' Aleman ';

        $experiencia->title = $request->title;
        $experiencia->description = $request->description;
        $experiencia->price = $request->price;
        $experiencia->hours = $request->hours;
        $experiencia->video = $request->video;
        $experiencia->includes = $request->includes;
        $experiencia->extra_indications = $request->extra_indications;
        $experiencia->what_bring = $request->what_bring;
        $experiencia->city = $request->city;
        $experiencia->province = $request->province;
        $experiencia->more_about = $request->more_about;
        $experiencia->location = $request->location;
        $experiencia->coordenates = $request->coordenates;
        $experiencia->languajes = $languajes;
        $experiencia->must_learn_languaje = $request->must_learn_languaje;
        $experiencia->title = $request->title;
        $experiencia->place = $request->location;
        $experiencia->reservations_phone = $request->reservations_phone;
        $experiencia->require_validation_user = $request->require_validation_user;
        $experiencia->reservation = $request->reservation == 1 ? 'Con reserva' : 'Sin reserva';
        $experiencia->place_id =  $request->place_id;

        if ($request->file('picture')) {
            $randomName = Str::random(20) .".".$request->picture->extension();
            $request->picture->storeAs('public/experiencias', $randomName);
            $experiencia->picture = $randomName;
        }

        $experiencia->main_page = 0;
        $experiencia->valid = 0;
        $experiencia->user_id = $user->id;
        $experiencia->title_en = $request->title;
        $experiencia->description_en = $request->description;

        if($request->iva_selector == 2)
        {
            $experiencia->price = $request->price;
            $experiencia->final_price = $request->price;
        }
        elseif ($request->iva_selector == 1)
        {
            $experiencia->price = $request->price;
            $experiencia->final_price = $request->price+($request->price*0.10);
        }
        else
        {
            $experiencia->price = $request->price;
            $experiencia->final_price = $request->price+($request->price*0.21);
        }
        $experiencia->iva_selector = $request->iva_selector;

        $experiencia->save();

        $categorias=collect();
        foreach ($request->categorias as $categoria_id) {
            $categorias->push(Category::find($categoria_id));
        }
        foreach ($categorias as $categoria) {
            $experiencia->categories()->sync($categoria, false);
        }
        //Edicion de imagenes extra de la experiencia
        //Si el preloaded se modifica se manda pero el tipo de dato enviado es array y no object
        if ($request->preloaded_images and gettype($request->preloaded_images[0]) == 'object') {

            foreach($request->file('preloaded_images') as $file){
                $image = new Image;
                $randomName = Str::random(20) .".". $file->extension();
                $image->url_image=$randomName;
                $file->storeAs('public/experiencias', $randomName);
                $image->name="Imagen secundaria";
                $image->is_principal=false;
                $image->experiencia_id=$experiencia->id;
                $image->save();
                }
        }
        elseif ($request->preloaded_images==null) {
            foreach ($experiencia->images->where('is_principal',false) as $imagenSecundaria) {
                $imagenSecundaria->delete();
            }
        }

        /*
        Si borran imagenes y quiero capturar cuales se borran, no me queda otra que comparar el tamaño
        del preloaded image que viene en el request vs la cantidad de imagenes que tenia asociado el modelo
        al mantener el orden solo resta saber que indices se eliminaron y borrarlos
        */

         elseif (count($experiencia->images) > count($request->preloaded_images)) {
             $values_stay_image = array_values($request->preloaded_images);
             $collecion_keys=array_keys($experiencia->images->toArray());
             $a=array_diff($collecion_keys,$values_stay_image);

            for ($i=0;  $i < count($a) ;$i++) {
                $experiencia->images[$i]->delete();
            }

        }




        return view('anfitriones.experiencia-editada', ['user'=>$user]);
}


    public function mis_experiencias(){
        $user = Auth::user();
        $experiencias = Experiencia::where('user_id', $user->id)->latest()->get();

        return view('anfitriones.mis-experiencias', [
            'experiencias'=>$experiencias,
            'user'=>$user,
        ]);
    }

    public function redimirCodigo()
    {
        $user = Auth::user();
        return view('anfitriones.redimir-codigo', ['user'=>$user]);
    }

    public function crear_experiencias(){
        $user = Auth::user();

        return view('anfitriones.crear-expe', [
            'user'=>$user,
            'categorias'=>Category::all(),
            'places'=>Place::all(),
        ]);
    }

    public function guardarNuevaExpe(AnfiExperienceRequest $request){
        $user = Auth::user();

        if($request->file('picture')->getSize() > 9049818)
        {
            return view('anfitriones.crear-expe', [
                'user'=>$user,
                'categorias'=>Category::all(),
                'places'=>Place::all(),
                'error_size'=>"El archivo que se subió es demasiado pesado. Maximo 10Mb"
            ]);
        }

        $experiencia = new Experiencia($request->toArray());

        $languajes = "";
        if($request->español == 'español')$languajes .= ' Español ';
        if($request->ingles == 'ingles')$languajes .= ' Ingles ';
        if($request->italiano == 'italiano')$languajes .= ' Italiano ';
        if($request->portugues == 'portugues')$languajes .= ' Portugues ';
        if($request->frances == 'frances')$languajes .= ' Frances ';
        if($request->aleman == 'aleman')$languajes .= ' Aleman ';


        $experiencia->video = $request->video;
        $experiencia->languajes = $languajes;
        $experiencia->place = $request->location;
        $experiencia->reservation = $request->reservation == 1 ? 'Con reserva' : 'Sin reserva';

        if ($request->file('picture')) {
            $randomName = Str::random(20) .".".$request->picture->extension();
            $request->picture->storeAs('public/experiencias', $randomName);
            $experiencia->picture = $randomName;
        }

        $experiencia->main_page = 0;
        $experiencia->valid = 0;
        $experiencia->user_id = $user->id;

        if($request->iva_selector == 2)
        {
            $experiencia->price = $request->price;
            $experiencia->final_price = $request->price;
        }
        elseif ($request->iva_selector == 1)
        {
            $experiencia->price = $request->price;
            $experiencia->final_price = $request->price+($request->price*0.10);
        }
        else
        {
            $experiencia->price = $request->price;
            $experiencia->final_price = $request->price+($request->price*0.21);
        }
        $experiencia->iva_selector = $request->iva_selector;

        $experiencia->title_en = $request->title;
        $experiencia->description_en = $request->description;

        $experiencia->save();

        if($request->file('extra_images')){
            foreach($request->file('extra_images') as $file){
                $image = new Image;
                $randomName = Str::random(20) .".". $file->extension();
                $image->url_image=$randomName;
                $file->storeAs('public/experiencias', $randomName);
                $image->name="Imagen subida";
                $image->experiencia_id=$experiencia->id;
                $image->save();
            }
        }

        $categorias=collect();
        foreach ($request->categorias as $categoria_id) {
            $categorias->push(Category::find($categoria_id));
        }
        foreach ($categorias as $categoria) {
            $experiencia->categories()->sync($categoria, false);
        }

        if($request->reservation == 1)
        {
            if($request->hora_inicio && ($request->hora_inicio!="0:00:00")){
                //Dias laborales
                // 1 => Domingo          5 => Jueves
                // 2 => Lunes            6 => Viernes
                // 3 => Martes           7 => Sabado
                // 4 => Miercoles

                //Quito el primer - del request por como llega desde el js
                if ($request->cantidad_de_dias[0]=='-') $request->cantidad_de_dias=ltrim($request->cantidad_de_dias, $request->cantidad_de_dias[0]);
                AllowedHours::create([
                    'experiencia_id'=>$experiencia->id,
                    'hora_desde'=>$request->hora_inicio,
                    'hora_hasta'=>'23:00:00',
                    'cantidad_de_reservas'=>(!$request->cantidad_de_reservas) ? 1 : $request->cantidad_de_reservas,
                    'dias_laborales'=>$request->cantidad_de_dias,
                ]);
            }
        }


        return view('anfitriones.experiencia-creada', [
            'user'=>$user,
        ]);
    }


    public function verificarCodigo(Request $request)
    {
        $user = Auth::user();
        $codigo = CodigoCanjeable::with(['venta' => function ($query) {
            $query->where('completed',1)->where('approved',1);
        }])->where('code', $request->code)->where('used', 0)->get()->first();

        if ($codigo==null) {
            return view('anfitriones.redimir-codigo', ['user'=>$user])->withErrors("El codigo ingresado no es valido");
        }

        //verificar que no este vencido
        if ($codigo->used==1) {
            return view('anfitriones.redimir-codigo', ['user'=>$user])->withErrors("El codigo ingresado ha expirado");
        }

        $codigo->used=1;
        $codigo->save();

        //$valor_a_facturar = $codigo->experiencia->price - ( $codigo->experiencia->price * 0.15 );
        $valor_a_facturar = $codigo->venta->amount - ( $codigo->venta->amount * 0.15 );
        //email al anfitrion
        $cuerpo_email = "<div style='text-align: center; padding-left: 15px; padding-right: 15px;'>
						    <h3>Hola</h3>
							<p>Entendemos que se realizó la experiencia asociada al Código ".$codigo->code.",
							por lo que el mismo perdió su vigencia.</p>
							<p>Envianos la factura por el valor de $".$valor_a_facturar." final con IVA incluido y discriminado.</p>
							<br />
							Datos de facturación:
							<br />Patricia Elda Querejeta
							<br />CUIT: 27-12768064-2
							<br />IVA : Responsable Inscripto
							<br />
							Cualquier duda o inconvenientes comunicate con nosotros escribiéndonos a adminstracion@yeah.com.ar.</p>
							<p>De Administración se comunicarán con ustedes confirmando el pago.</p>
							<p>Que tengas un buen día.</p>
						<div>";

        $mail = new Mailer();
        $mail->confirmarEnvioFactura($user->email,$cuerpo_email,$codigo->code);

        //email al comprador
        $mail2 = new Mailer();
        $cuerpo_email = "<div style='text-align: center; padding-left: 15px; padding-right: 15px;'>
							<div style='text-align: center;'>
                                <h2>¡Hola!</h2>
                                <p>¿Qué te pareció la Experiencia ".$codigo->experiencia->title."?</p>
                                <p>Otros compradores quieren saber que tal la pasaste. ¡Danos tu opinión!</p>
                                <br /><br />
                                <a href='https://yeah.com.ar/calificar-experiencia/".$codigo->experiencia->id."'
                                style='background-color: #ffc107;
                                margin: 5px;
                                text-decoration: none;
                                padding: 15px !important;
                                border: 1px solid #ffc107;
                                color: black;'>Calificar</a>
                                <br>
                                <br>
                                <p>¡Que tengas un buen día!</p>
                            </div>
						<div>";

        $mail2->calificaLaExperiencia($codigo->user_gifted, $cuerpo_email, $cuerpo_email);

        //email al anfitrion
        return view('anfitriones.resultado-codigo', [
            'user'=>$user,
            'codigo'=>$codigo,
            'monto_factura'=>$valor_a_facturar,
        ]);
    }
}
