<?php

namespace App\Http\Controllers;

use App\Http\Requests\UserDetailsRequest;
use App\Models\Experiencia;
use App\Models\User;
use App\Models\UsersDetail;
use App\Models\Venta;
use Carbon\Carbon;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class AdministrationController extends Controller
{
    public function home(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1) return redirect('/');
        return view('admin.home', [
            'user'=>Auth::user(),
            'ventas'=>Venta::with('experiencia')->has('experiencia')->orderBy('id', 'desc')->take(10)->get(),
            'ventas_totales'=>Venta::all(),
            'experiencias'=>Experiencia::with('ventas')->get(),
            //'ventas_hoy'=>Venta::whereDate('created_at', Carbon::today())->count(),
            'ventas_hoy'=>Venta::where('approved', 1)->whereDate('created_at', Carbon::today())->get(),
            'users'=>User::where('role_id', 2)->get(),
        ]);

    }
    //Metodos GET
    public function getUsers(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.usuario.index', ['users'=>User::orderBy('id', 'desc')->  paginate(10)]);
    }

    public function getDeletedUsers(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.usuario.softdelete',['users'=>User::onlyTrashed()->paginate(10)]);
    }

    public function getAnfitriones(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.usuario.anfitriones', ['users'=>User::where('role_id', 3)->orderBy('id', 'desc')->paginate(10)]);
    }

    public function getClients(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.usuario.clientes', ['users'=>User::where('role_id', 2)->orderBy('id', 'desc')->paginate(10)]);
    }

    //Metodos delete
    public function softdeleteUser(User $user)
    {
        if(Auth::user()->role_id == 1)$user->delete();
            return redirect()->route('admin.users');
    }

    public function restoreUser(Request $request){
        if(Auth::user()->role_id != 1)return redirect('/');
        User::onlyTrashed()->where('id', $request->id)->restore();
        return redirect()->route('admin.users.deleted');
    }

    public function deleteUser(Request $request){
        if(Auth::user()->role_id != 1)return redirect('/');
            User::onlyTrashed()->where('id', $request->id)->forceDelete();
            return redirect()->route('admin.users.deleted');
    }

    public function createAnfitrion()
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.usuario.nuevo-anfitrion');

    }

    public function storeAnfitrion(Request $request)
    {
        $Uservalidated = $request->validate([
            'name' => 'required',
            'email' => 'required',
            'password' => 'required',
            'gender' => 'required',
            'city' => 'required',
            'phone' => 'required',
            'province' => 'required',
            'country' => 'required',
        ]);

        $UserDetailsvalidated = $request->validate([
            'fake_name' => 'required',
            'company_type' => 'required',
            'address' => 'required',
            'mobile_phone' => 'required',
            'more_information' => 'required',
            'company_address' => 'required',
            'company_city' => 'required',
            'company_province' => 'required',
            'reservation_phone' => 'required',
            'responsable_inscripto' => 'required',
            'cuit' => 'required',
            'company_bank' => 'required',
            'cbu' => 'required',
            'iva_percentaje' => 'required',
            'alias' => 'required',
            'mercado_pago_user' => 'required',

        ]);

        if(Auth::user()->role_id != 1)return redirect('/');

        try {
            DB::transaction(function () use ($Uservalidated,$request,$UserDetailsvalidated) {
                $user =User::create($Uservalidated+[
                    'password'=>Hash::make($request->password),
                    'state' => 1,
                    'role_id' => 3,
                    'verified' => 1
                ]);

                if($request->file('picture') != null){
                    $randomName = Str::random(20) .".". $request->file('picture')->extension();

                    $request->file('picture')->storeAs('public/anfitriones', $randomName);

                    $user->picture = $randomName;
                }
                UsersDetail::create($UserDetailsvalidated+[
                    'status' => 1,
                    'user_id' => $user->id,
                    'company_name'=>'No definida'
                ]);
            });
        return redirect('/anfitriones');

        }  catch(Exception $e){
                return $e;
        }
    }

    public function edit(User $user)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.usuario.edit-anfitrion',['user'=>$user]);
    }

    public function editAll($id)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $usuario = User::find($id);
        return view('admin.usuario.edit-client',['user'=>$usuario]);
    }

    public function saveEdit(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $usuario = User::find($request->user_id);

        $usuario->name = $request->name;
        $usuario->email = $request->email;
        $usuario->gender = $request->gender;
        $usuario->city = $request->city;
        $usuario->phone = $request->phone;
        $usuario->province = $request->province;
        $usuario->country = $request->country;

        $usuario->save();

        return redirect('/usuarios/editar/'.$usuario->id);
    }

    public function update(User $user,Request $request,UserDetailsRequest $requestUserDetail)
    {
        $validated = $request->validate([
            'name' => 'required',
            'email' => 'required',
            'gender' => 'required',
            'city' => 'required',
            'phone' => 'required',
            'province' => 'required',
            'country' => 'required',
        ]);

        try {
            DB::transaction(function () use ($validated,$requestUserDetail,$user,$request) {
                $user->update($validated);

                UsersDetail::where('user_id', $user->id)->first()->update($requestUserDetail->all());

                $imagen =$request->host_picture->getClientOriginalName();
                $filePath = $request->file('host_picture')->storeAs('/anfitriones', $imagen, 'public');

                //Sube la imagen temporal de momento
                UsersDetail::where('user_id', $user->id)->first()->update(array('host_picture' =>$filePath));

                if($request->password)
                {
                    $user->password = Hash::make($request->password);
                    $user->save();
                }
            });
            return redirect('/anfitriones');

        }  catch(ModelNotFoundException $findorFail){
                return redirect('/anfitriones')->withErrors(['msg' => 'User doesnt have a UserDetails profile , update canceled']);
        }
        catch(Exception $e){
                return redirect()->route('admin.users.edit',['user'=>$user]);
        }
    }
    public function validateUser(Request $request)
    {
        try {
            DB::transaction(function () use($request){
                User::where('id',$request->user_id)->update(array('verified' => 1));
        });
        if ($request->anfitrion==2)return redirect()->route('admin.anfitriones.index');

        return redirect()->route('admin.users');

        }  catch(Exception $e){
            return redirect()->route('admin.users');
        }
    }
}
