<?php

namespace App\Http\Controllers;

use App\Exports\VentasExport;
use App\Models\Reserva;
use App\Models\Venta;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class AdminVentasController extends Controller
{
    public function getVentas(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.venta.index', [
            'ventas'=>Venta::where('completed', 1)
                ->where('approved', 1)
                ->orderBy('id', 'desc')
                ->paginate(20),
            'tipo'=>"totales",
        ]);
    }

    public function getVentasSinReserva(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        $ventas = Venta::whereHas('experiencia', function ($query){
            $query->where('reservation', '=', 0);
        })->orderBy('id', 'desc')->paginate(20);

        return view('admin.venta.index', [
            'ventas'=>$ventas,
            'tipo'=>"sin reserva",
        ]);
    }

    public function getVentasConReserva(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');


        $reservas = Reserva::whereHas('experiencia', function ($query){
            $query->where('valid', '=', 1);
        })->orderBy('id', 'desc')->paginate(20);

        return view('admin.venta.con-reserva', [
            'reservas'=>$reservas,
            'tipo'=>"con reserva",
        ]);
    }

    public function getVentasDeCanje()
    {
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        $ventas = Venta::whereHas('experiencia', function ($query){
            $query->where('reservation', '=', 0);
        })
            ->whereHas('codigoCanjeable', function ($query){
                $query->where('from_canje', '=', 1);
            })
            ->orderBy('id', 'desc')
            ->paginate(20);

        return view('admin.venta.canje-tabla', [
            'ventas'=>$ventas,
            'tipo'=>"Canje/Puntos",
        ]);
    }

    public function getExperienciasRealizadas()
    {
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        $ventas = Venta::with('experiencia')
            ->where('approved',1)
            ->whereHas('codigoCanjeable', function($query) {
                return $query->where('used', 1);
            })
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('admin.venta.experiencias-realizadas', compact(['ventas']));
    }

    public function exportarVentas()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return Excel::download(new VentasExport, 'ventas.xlsx');
    }
    public function delete(Venta $venta)
    {
        if(!(Auth::user()->isAdmin()))return redirect('/');

        $venta->delete();
        return redirect()->route('venta.index');
    }
}
