<?php

namespace App\Http\Controllers;

use App\Models\Pregunta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminPreguntasController extends Controller
{
    public function getPreguntas()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $preguntas = Pregunta::paginate(20);
        return view('admin.preguntas.index', [
            'preguntas'=>$preguntas
        ]);
    }

    public function responderPregunta(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $pregunta = Pregunta::find($request->pregunta);
        $pregunta->respuesta = $request->respuesta;
        $pregunta->valida_front = 1;
        $pregunta->save();
        return redirect('/ver-preguntas');
    }

    public function borrarPregunta(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $pregunta = Pregunta::find($request->pregunta);
        $pregunta->delete();
        return redirect('/ver-preguntas');
    }
}
