<?php

namespace App\Http\Controllers;

use App\Models\Place;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class AdminPlaceController extends Controller
{

    public function getPlaces(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.place.lugares', ['lugares'=>Place::paginate(20)]);
    }

    public function getDeletedPlaces(){
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.place.softdelete',['lugares'=>Place::onlyTrashed()->paginate(20)]);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.place.crear');
    }

    public function edit(Place $place)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.place.edit',['place'=>$place]);
    }

    public function store(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $validated = $request->validate([
            'name' => 'required',
            'image' => 'required | array',
            'image.*' => 'required |mimes:jpg,png,jpeg,gif,svg|max:4096',
            'status' => 'required',
        ]);

        
        $place= new Place($validated);
        
        
        $randomName = Str::random(20) .".". $request->file('image')[0]->extension();
        $request->file('image')[0]->storeAs('public/places', $randomName);
        $place->image = $randomName;
        
        $place->save();

        return redirect('/lugares');
    }

    public function update(Request $request ,Place $place)
    {
        $validated = $request->validate([
            'name' => 'required',
            'status' => 'required',
        ]);
        $place->update($validated);
        if($request->file('preloaded')){
            $randomName = Str::random(20) .".". $request->file('preloaded')->extension();
            $request->file('preloaded')->storeAs('public/places', $randomName);
            $place->image = $randomName;
        
            $place->save();
        }
        return redirect()->route('admin.places');
    }
    public function softdeletePlace(Place $place)
    {
        if(Auth::user()->role_id == 1)$place->delete();
        return redirect()->route('admin.places');
    }
    public function restorePlace(Request $request){
        if(Auth::user()->role_id != 1)return redirect('/');

        Place::onlyTrashed()->where('id', $request->id)->restore();
        return redirect('/lugares');
    }
    public function deletePlace(Request $request){
        if(Auth::user()->role_id != 1)return redirect('/');

        Place::onlyTrashed()->where('id', $request->id)->forceDelete();
        return redirect('/lugares');
    }
}
