<?php

namespace App\Http\Controllers;

use App\Http\Requests\ExperienciaRequest;
use App\Models\Calification;
use App\Models\Category;
use App\Models\CodigoCanjeable;
use App\Models\Experiencia;
use App\Models\Image;
use App\Models\Place;
use App\Models\Pregunta;
use App\Models\User;
use App\Models\Venta;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class AdminExperienciasController extends Controller
{

    public function crearNueva(){
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.experiencia.crear', [
            'lugares'=>Place::all(),
            'users'=>User::has('user_details')->where('role_id',3)->get(),
            'categorias'=>Category::all(),
        ]);
    }

    public function guardarNueva(ExperienciaRequest $request){
        if(!(Auth::user()->isAdmin()))return redirect('/');

        $categorias = collect();
        foreach ($request->categorias as $categoria_id) {
            $categorias->push(Category::find($categoria_id));
        }
        $languajes = "";
        if($request->español == 'español')$languajes .= ' Español ';
        if($request->ingles == 'ingles')$languajes .= ' Ingles ';
        if($request->italiano == 'italiano')$languajes .= ' Italiano ';
        if($request->portugues == 'portugues')$languajes .= ' Portugues ';
        if($request->frances == 'frances')$languajes .= ' Frances ';
        if($request->aleman == 'aleman')$languajes .= ' Aleman ';

        try {
            DB::transaction(function () use ($categorias,$languajes,$request) {
                $main_image = new Image;
                $file = $request->file('main_image');
                $randomName = $file->hashName();

                $main_image->url_image = $randomName;
                $file->storeAs('public/experiencias', $randomName);


                $experiencia =  Experiencia::create($request->validated()+[
                    'reservation' => $request->reservation == 1 ? 'Con reserva' : 'Sin reserva',
                    'languajes' => $languajes,
                    'title_en' => $request->title_en ? $request->title_en : 'Translate pending',
                    'description_en' => $request->description_en ? $request->description_en : 'Translate pending',
                    'location' => $request->place,
                    'reservations_phone'=> $request->reservations_phone,
                    'valid' => 1,
                    'final_price' => round($request->price*1.15/10)*10,
                    'video' => $request->video ? $request->video : null,
                    'picture' => $main_image->url_image,
                ]);
                $main_image->experiencia_id = $experiencia->id;
                $main_image->name = "Imagen principal";
                $main_image->is_principal=true;

                $main_image->save();


                foreach ($categorias as $categoria) {
                    $experiencia->categories()->sync($categoria, false);
                }

                if ($request->file('extra_images')) {
                foreach($request->file('extra_images') as $file){
                    $image = new Image;
                    $randomName = $experiencia->id . '_' . $file->hashName();
                    $image->url_image = $randomName;
                    $file->storeAs('public/experiencias', $randomName);
                    $image->name = "Imagen extra";
                    $image->is_principal = false;
                    $image->experiencia_id = $experiencia->id;
                    $image->save();
                }
            }
            });
            return redirect('/experiencias');
        }
        catch(Exception $e){
            return view('errors.500');
        }
    }

    //Todo esto es igual que el metodo restore en la linea 140
    // public function activate(Request $request)
    // {
    //     if (!Auth::check())return redirect('/login');
    //     if(Auth::user()->role_id != 1)return redirect('/');

    //     $expe = Experiencia::find($request->id);
    //     $expe->valid = 1;
    //     $expe->save();
    //     return view('admin.experiencia.index', ['experiencias'=>Experiencia::where('valid', 1)->paginate(20)]);
    // }

    public function getExperiencias(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.experiencia.index', ['experiencias'=>Experiencia::withTrashed()->orderBy('id', 'desc')->paginate(20)]);
    }

    public function getExperienciasActivas(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.experiencia.index', ['experiencias'=>Experiencia::where('valid', 1)->orderBy('id', 'desc')->paginate(20)]);
    }

    public function getExperienciasDestacadas(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.experiencia.index', ['experiencias'=>Experiencia::where('main_page', 1)->paginate(20)]);
    }

    public function getExperienciasPendientes(){
        if (!Auth::check())return redirect('/login');
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.experiencia.index_softdelete', ['experiencias'=>Experiencia::onlyTrashed()->paginate(20)]);
    }
    public function delete(Experiencia $experiencia)
    {
        if(!(Auth::user()->isAdmin()))return redirect('/');

        $experiencia->valid = 0;
        $experiencia->save();
        $experiencia->delete();

        Venta::where('experiencia_id', $experiencia->id)->delete();
        CodigoCanjeable::where('experiencia_id', $experiencia->id)->delete();
        Calification::where('experiencia_id', $experiencia->id)->delete();
        Pregunta::where('experiencia_id', $experiencia->id)->delete();

        return redirect()->route('experiencias');
    }
    public function restore(Request $request)
    {
        if(!(Auth::user()->isAdmin()))return redirect('/');

        Experiencia::onlyTrashed()->where('id', $request->id)->restore();
        $experiencia=Experiencia::find($request->id);
        $experiencia->valid = 1;
        $experiencia->save();
        return redirect()->route('experiencias.softdeleted');
    }

    public function forceDelete(Request $request)
    {
        if(!(Auth::user()->isAdmin()))return redirect('/');

        Experiencia::onlyTrashed()->where('id', $request->id)->forceDelete();
        return redirect()->route('experiencias.softdeleted');
    }

    public function edit(Experiencia $experiencia)
    {
        return view('admin.experiencia.edit', [
            'experiencia'=>$experiencia,
            'lugares'=>Place::all(),
            'users'=>User::has('user_details')->where('role_id',3)->get(),
            'categorias'=>Category::all()->unique('title'),
        ]);
    }

    public function update(Experiencia $experiencia,ExperienciaRequest $request)
    {
        //Este metodo se puede hacer refactor para que se entienda mejor
        if(Auth::user()->role_id != 1)return redirect('/');

        $categorias=collect();
        foreach ($request->categorias as $categoria_id) {
            $categorias->push(Category::find($categoria_id));
        }

        $languajes = "";
        if($request->español == 'español')$languajes .= ' Español ';
        if($request->ingles == 'ingles')$languajes .= ' Ingles ';
        if($request->italiano == 'italiano')$languajes .= ' Italiano ';
        if($request->portugues == 'portugues')$languajes .= ' Portugues ';
        if($request->frances == 'frances')$languajes .= ' Frances ';
        if($request->aleman == 'aleman')$languajes .= ' Aleman ';

        try {
            DB::transaction(function () use ($categorias, $languajes, $request, $experiencia) {

                $new_main_image = null;

                //Se modifico LA imagen Principal
                if ( !isset($request->old_main_image) && $file = $request->file('main_image')) {
                    Image::where('experiencia_id',$experiencia->id)->where('is_principal',true)->delete();
                    $new_main_image = new Image;
                    $randomName = $file[0]->hashName();
                    $new_main_image->url_image = $randomName;
                    $file[0]->storeAs('public/experiencias', $randomName);
                    $new_main_image->name= "Imagen principal";
                    $new_main_image->is_principal = true;

                    $new_main_image->experiencia_id = $experiencia->id;
                    $new_main_image->save();
                }

                $experiencia->update($request->validated()+[
                    'title_en'=> $request->title_en ? $request->title_en : 'Translate pending',
                    'description_en'=> $request->description_en ? $request->description_en : 'Translate pending',
                    'reservation'=>$request->reservation == 1 ? 'Con reserva' : 'Sin reserva',
                    'languajes'=> $languajes,
                    'location'=> $request->place,
                    'reservations_phone'=> $request->reservations_phone,
                    'final_price'=>$request->final_price? $request->final_price : round($request->price*1.15/10)*10,
                    'valid'=> $request->valid,
                    'video'=>$request->video ? $request->video : null,
                    'picture' => $new_main_image ? $new_main_image->url_image : $experiencia->picture,
                ]);

                /*
                    Si existe $request->old_extra_images esto es un array con los IDs de las imagenes que no se borraron
                */

                // Borro las imagenes que existian y fueron quitadas
                if (isset($request->old_extra_images)) {
                    Image::where('experiencia_id', $experiencia->id)
                        ->where('is_principal',false)
                        ->whereNotIn('id', $request->old_extra_images)
                        ->delete();
                }

                // Creo Las nuevas imagenes cargadas
                if ($request->extra_images) {
                    foreach($request->file('extra_images') as $file){
                        $image = new Image;
                        $randomName = $file->hashName();
                        $image->url_image=$randomName;
                        $file->storeAs('public/experiencias', $randomName);
                        $image->name="Imagen extra";
                        $image->is_principal = false;
                        $image->experiencia_id = $experiencia->id;
                        $image->save();
                    }
                }

                foreach ($categorias as $categoria) {
                    $experiencia->categories()->sync($categoria, false);
                }
            });
            return redirect('/experiencias');
        }
        catch(Exception $e){
            return view('errors.500');
        }
    }
}
