<?php

namespace App\Http\Controllers;

use App\Models\Envio;
use App\Models\Experiencia;
use App\Models\PickUp;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminEnviosRetirosController extends Controller
{
    public function envios()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.envios.index', [
            'envios'=>Envio::paginate(10),
        ]);
    }

    public function retiros()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.pickup.index', [
            'pickups'=>PickUp::paginate(10),
        ]);
    }

    public function create()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.pickup.create',['experiencias'=>Experiencia::with('ventas')->get(),'users'=>User::all()]);
    }

    public function completarEnvio(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $envio = Envio::find($request->id);
        $envio->enviado = true;
        $envio->save();
        return redirect('envios');
    }

    public function completarRetiro(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $pickup = PickUp::find($request->id);
        $pickup->retirado = true;
        $pickup->save();
        return redirect('retiros');
    }
    public function delete(PickUp $pickUp)
    {
        if(!(Auth::user()->isAdmin()))return redirect('/');
    
        $pickUp->delete();
        return redirect()->route('retiros.index');
    }
    public function delete_envio(Envio $envio)
    {
        if(!(Auth::user()->isAdmin()))return redirect('/');
    
        $envio->delete();
        return redirect()->route('envios.index');
    }
}
