<?php

namespace App\Http\Controllers;

use App\Models\Contacto;
use App\Models\ContactoEmpresa;
use Illuminate\Http\Request;


class AdminContactosController extends Controller
{
    public function getContactos()
    {
        return view('admin.contactos.index', [
            'contactos'=>Contacto::orderBy('id', 'desc')->paginate(10),
        ]);
    }

    public function getContactosEmpresas()
    {
        return view('admin.contactos.empresas', [
            'contactos'=>ContactoEmpresa::orderBy('id', 'desc')->paginate(10),
        ]);
    }

    public function deleteContact(Request $request)
    {
        $contact = Contacto::find($request->contact_id);
        $contact->delete();
        return redirect('/contactos');
    }
}
