<?php

namespace App\Http\Controllers;

use App\Models\Configuration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminConfiguracionesController extends Controller
{
    public function index()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.configuraciones.index', [
            'costo_envio'=>Configuration::where('name', 'costo de envio')->first(),
            'configuracion_mp'=>Configuration::where('name', 'MercadoPago')->first(),
            'configuracion_stripe'=>Configuration::where('name', 'Stripe')->first(),
            'configuracion_correo'=>Configuration::where('name', 'Correo')->first(),
        ]);
    }

    public function guardarGastosEnvio(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $configuracion = Configuration::where('name', 'costo de envio')->first();
        if($configuracion)
        {
            $configuracion->key = $request->costoEnvio;
            $configuracion->save();
        }
        else{
            $configuracion = new Configuration();
            $configuracion->name = "costo de envio";
            $configuracion->user = "-";
            $configuracion->key = $request->costoEnvio;
            $configuracion->save();
        }
        return redirect('/configuraciones');
    }

    public function guardarMercadoPago(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $configuracion = Configuration::where('name', 'MercadoPago')->first();
        $configuracion->name = $request->name;
        $configuracion->user = $request->user;
        $configuracion->key = $request->key;

        $configuracion->save();

        return redirect('/configuraciones');
    }

    public function guardarStripe(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $configuracion = Configuration::where('name', 'Stripe')->first();
        $configuracion->name = $request->name;
        $configuracion->user = $request->user;
        $configuracion->key = $request->key;

        $configuracion->save();

        return redirect('/configuraciones');
    }

    public function guardarEmail(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $configuracion = Configuration::where('name', 'Correo')->first();
        $configuracion->name = $request->name;
        $configuracion->user = $request->user;
        $configuracion->key = $request->key;

        $configuracion->save();

        return redirect('/configuraciones');
    }

    public function nuevaIntegracion(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $configuracion = new Configuration();
        $configuracion->name = $request->name;
        $configuracion->user = $request->user;
        $configuracion->key = $request->key;

        $configuracion->save();

        return redirect('/configuraciones');
    }
}
