<?php

namespace App\Http\Controllers;

use App\Exports\LoteExport;
use App\Models\CashDiscountCoupon;
use App\Models\CodigoCanjeable;
use App\Models\CodigoDescuento;
use App\Models\Experiencia;
use App\Models\LoteCodigo;
use App\Models\User;
use App\Models\Venta;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Maatwebsite\Excel\Facades\Excel;

class AdminCodigoController extends Controller
{
    public function codigos()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.codes.codigos', [
            'codigos'=>CodigoCanjeable::latest()->paginate(10),
            'codigos_descuento'=>CodigoDescuento::latest()->paginate(10),
        ]);
    }

    public function lotes()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.codes.lotes_index', [
            'lotes'=>LoteCodigo::paginate(10),
        ]);
    }

    public function crearLote()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.codes.crear-lote', [
            'experiencias'=>Experiencia::all(),
            'users'=>User::all(),
        ]);
    }

    public function storeLote(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $venta = new Venta();
        $venta->experiencia_id = $request->experiencia_id;
        $venta->user_id = $request->user_buyer;
        $venta->preference_id = "Lote";
        $venta->amount = 0;
        $venta->completed = 1;
        $venta->approved = 1;
        $venta->save();

        $lote = new LoteCodigo();
        $lote->title = $request->title;
        $lote->amount = $request->ammount;
        $lote->save();

        for($i = 0; $i<$request->ammount; $i++)
        {
            $code = new CodigoCanjeable();
            $code->code = Str::random(10);
            $code->experiencia_id = $request->experiencia_id;
            $code->lote_id = $lote->id;
            $code->used = 0;
            $code->list_of_codes = 1;
            $code->date_exp = Carbon::now()->addDays(90);
            $code->user_buyer = $request->user_buyer;
            $code->venta_id = $venta->id;
            $code->user_gifted = "-";
            $code->name = "-";
            $code->message = "-";
            $code->save();
        }

        return view('admin.codes.lote-creado', [
            'cantidad_codigos'=>$request->ammount,
            'nombre_lote'=>$lote->title,
            'lote_id'=>$lote->id,
        ]);
    }

    public function codigosDelLote($id)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $lote = LoteCodigo::find($id);

        $codigos = CodigoCanjeable::where('lote_id', $lote->id)
            ->orderBy('id', 'desc')
            ->get();

        return view('admin.codes.codigos_lote', [
            'codigos'=>$codigos,
        ]);
    }

    public function exportLote(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $lote = $request->lote_id;

        return Excel::download(new LoteExport($lote), $request->lote_name.'.xlsx');
    }

    public function createCodigo()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.codes.crear', [
            'experiencias'=>Experiencia::all(),
            'users'=>User::all(),
        ]);
    }

    public function storeCodigo(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        if($request->custom_code=="custom"){
            $date = Carbon::now();
            $exp_date = $date->add(30, 'day');
            try {
                DB::transaction(function () use ($exp_date,$request){
                    $codigo =CodigoDescuento::create([
                        'code' => $request->code,
                        'apply_on_experiencia_id' => $request->experiencia_id=="custom" ? null : $request->experiencia_id,
                        'used' => 0,
                        'discount'=> $request->discount,
                        'date_exp' => $exp_date,
                    ]);
                });
                return Redirect::back()->with('success', 'Codigo " '.$request->code.'" generado con exito!');

            } catch (\Throwable $th) {
                return Redirect::back()->withErrors(['msg' =>'Ocurrio un problema al crear el codigo']);
            }
        }else{

        $venta = new Venta();
        $venta->experiencia_id = $request->experiencia_id;
        $venta->user_id = $request->user_buyer;
        $venta->preference_id = "Back-End";
        $venta->amount = 0;
        $venta->completed = 1;
        $venta->approved = 1;
        $venta->save();

        $codigo = new CodigoCanjeable();
        $codigo->code = $request->code;
        $codigo->experiencia_id = $request->experiencia_id;
        $codigo->used = 0;
        $codigo->list_of_codes = 0;
        $date = Carbon::now();
        $exp_date = $date->add(90, 'day');
        $codigo->date_exp = $exp_date;
        $codigo->user_buyer = $request->user_buyer;

        $user = User::find($request->user_gifted);

        $codigo->user_gifted = $user->email;
        $codigo->venta_id = $venta->id;
            try{
                $codigo->save();
                return redirect('/codigos');
            }
            catch (QueryException $e){
                return view('admin.codes.crear', [
                    'experiencias'=>Experiencia::all(),
                    'users'=>User::all(),
                    'error'=>'El código ingresado ya existe en la base de datos. Por favor, especifique un código distinto.'
                ]);
            }
        }
    }

    public function createCodigoExcel()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.codes.cargarExcel');
    }
    public function readCodigoExcel(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $excel=Excel::toArray(new CodigoCanjeable, $request->file('excel'));
        $resultado=AdminCodigoController::createUsersCodigoExcel($excel);

        if (gettype($resultado) != "string") {
            if (gettype($resultado) != 'array') {
                return view('errors.error_messsage_template', ['title'=>'Error en el formato del excel','tabla'=>$resultado]);
            }
            return view('admin.codes.indexCodigosExcel', ['results'=>$resultado]);
        }else {
            return view('errors.error_messsage_template', ['title'=>'Error en el formato del excel','description'=>$resultado]);
        }

    }
    public static function createUsersCodigoExcel($array_excel)
    {
        $filas=$array_excel[0][0];
        $filas = Arr::flatten($filas);
        $filas = array_map('trim', $filas);
        $new_users=collect();
        $codes=collect();
        if(in_array('Nombre', $filas) and in_array('Apellido', $filas) and  in_array('Teléfono', $filas) and in_array('Experiencia', $filas) and (in_array('Correo', $filas) or in_array('Email', $filas))){
            $posicion_nombre =array_search('Nombre', $filas);
            $posicion_apellido =array_search('Apellido', $filas);
            $posicion_tel =array_search('Teléfono', $filas);
            $posicion_canje =array_search('Experiencia', $filas);
            if(in_array('Correo', $filas)){
                $posicion_correo =array_search('Correo', $filas);
            }else {
                $posicion_correo =array_search('Email', $filas);
            }



        try {
            DB::transaction(function () use ($posicion_nombre,$posicion_tel,$posicion_canje,$posicion_apellido,$posicion_correo,$array_excel,$new_users,$codes) {
                foreach ($array_excel[0] as $datos) {
                    //Puede suceder que el excel lea todo el excel generando casillas con valores nulos
                    //Para eso compruebo si el valor dentro de las posiciones debidas son distintos a nulos
                    if ($datos[$posicion_nombre]  == null and $datos[$posicion_correo] ==null) continue;
                    if ($datos[$posicion_tel]  == 'Teléfono') continue;
                    //Primero buscamos si los usuarios del excel existen
                    //Si no existen los creamos y los almacenamos en una collection
                    //esta collection vamos a mostrar despues de cargar el excel

                    $user=User::firstOrCreate(
                        ['email' => $datos[$posicion_correo]],
                        ['name' => $datos[$posicion_nombre].' '.$datos[$posicion_apellido],
                            'phone' => $datos[$posicion_tel],
                            'gender'=> 'No definido',
                            'city'=> 'No definido',
                            'province'=> 'No definido',
                            'country'=> 'No definido',
                            'role_id'=> 2,
                            'password'=> Hash::make('contraseña'),
                            'state'=> 2,
                        ]);
                    $new_users->push($user);
                        $venta=Venta::create([
                            'experiencia_id'=>Experiencia::where('title',$datos[$posicion_canje])->firstOrFail()->id,
                            'user_id'=>$user->id,
                            'amount'=>Experiencia::where('title',$datos[$posicion_canje])->firstOrFail()->final_price,
                            'approved'=>1,
                            'completed'=>1,
                        ]);

                    $code=CodigoCanjeable::create([
                        'code' => Str::random(10),
                        'venta_id' => $venta->id,
                        'used' => 0,
                        'list_of_codes' => false,
                        'date_exp' => Carbon::now()->addDays(90),
                        'experiencia_id' => Experiencia::where('title',$datos[$posicion_canje])->firstOrFail()->id,
                        'name' => $user->name,
                        'message' => null,
                        'user_buyer' => $user->id,
                        'user_gifted' => $user->email,
                        'from_canje' => 1,
                    ]);
                    $codes->push($code);
                    }
                });
                }
                catch(ModelNotFoundException $e){
                    return "El nombre de la experiencia no fue encontrado. Por favor revise que este bien escrito";

                } catch (\Throwable $th) {
                    return "El excel ingresado no corresponde al formato necesario. Revise que no falten las columnas necesarias";
                }
                return array('users' => $new_users,'codes' =>$codes);
        }
        else {
            $valores_encontrados=collect();
            $valores_encontrados->push('El excel ingresado no corresponde al formato necesario. Revise que no falten las columnas necesarias');
            foreach ($array_excel[0][0] as $datos) {
                $valores_encontrados->push($datos);
            }
            return $valores_encontrados;
        }
    }
    public function deleteCodigo(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        if($request->discount_code=='x'){
            $codigo_descuento = CodigoDescuento::find($request->id);
            $codigo_descuento->delete();
        }else{
            $codigo = CodigoCanjeable::find($request->id);
            $codigo->delete();
        }
            return redirect('/codigos');
    }



    public function createCodigoPorMonto()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.codes.crear_monto', [
            'users'=>User::all(),
        ]);
    }

    public function storeCodigoPorMonto(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        CashDiscountCoupon::create([
            'code'=>$request->code,
            'amount'=>$request->amount,
        ]);

        return redirect('/codigos-de-descuento-monto');
    }

    public function descuentosPorMonto()
    {
        $codigos = CashDiscountCoupon::paginate(20);

        return view('admin.codes.codigos_monto', [
            'users'=>User::all(),
            'codigos'=>$codigos,
        ]);
    }

    public function deleteCodigoPorMonto(Request $request)
    {
        $code = CashDiscountCoupon::find($request->code_id);
        $code->delete();
        return redirect('/codigos-de-descuento-monto');
    }
}
