<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class AdminCategoriasController extends Controller
{
    public function categorias()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.category.index', [
            'categorias'=>Category::paginate(10),
        ]);
    }

    public function createCategoria()
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.category.crear');
    }

    public function storeCategoria(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $categoria = new Category();

        $categoria->title = $request->title;
        $categoria->description = $request->description;
        if($request->file('picture') != null){
            $randomName = Str::random(20) .".". $request->file('picture')->extension();
            $request->file('picture')->storeAs('public/categorias', $randomName);
            $categoria->picture = $randomName;
        }
        $categoria->state = 1;

        $categoria->save();

        return redirect('/categorias');
    }

    public function editCategoria($id)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        return view('admin.category.edit', [
            'categoria'=>Category::find($id)
        ]);
    }

    public function updateCategoria(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $categoria = Category::find($request->id);

        $categoria->title = $request->title;
        $categoria->description = $request->description;
        if($request->file('picture') != null){
            $randomName = Str::random(20) .".". $request->file('picture')->extension();
            $request->file('picture')->storeAs('public/categorias', $randomName);
            $categoria->picture = $randomName;
        }
        $categoria->save();

        return redirect('/categorias');
    }

    public function dropDownCategory(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $categoria = Category::find($request->id);
        $categoria->state = 0;
        $categoria->save();
        return redirect('/categorias');
    }

    public function activeCategory(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $categoria = Category::find($request->id);
        $categoria->state = 1;
        $categoria->save();
        return redirect('/categorias');
    }

    public function deleteCategoria(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');
        $categoria = Category::find($request->id);
        $categoria->delete();
        return redirect('/categorias');
    }
}
