<?php

namespace App\Http\Controllers;

use App\Models\Calification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminCalificationsController extends Controller
{
    public function getCalifications()
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        return view('admin.califications.index', [
            'califications'=>Calification::paginate(15),
        ]);
    }

    public function saveCalification(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $calification = Calification::find($request->id);
        $calification->valida_front = 1;
        $calification->save();

        return redirect('/califications');
    }

    public function deleteCalificacion(Request $request)
    {
        if(Auth::user()->role_id != 1)return redirect('/');

        $calification = Calification::find($request->id);
        $calification->valida_front = 1;
        $calification->delete();

        return redirect('/califications');
    }
}
